/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.handler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdklog.logging.core.manager.LogManagerUtils;

public class StudyRejectedPolicy
implements RejectedExecutionHandler {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    @Override
    public final void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        if (!e.isShutdown()) {
            String unique = LogManagerUtils.getProperty(".unique", "false");
            if (unique.equals("false")) {
                r.run();
            } else {
                this.executionTask(r, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executionTask(Runnable r, ThreadPoolExecutor e) {
        BlockingQueue<Runnable> queue = e.getQueue();
        while (!queue.offer(r) && !Thread.currentThread().isInterrupted()) {
            this.lock.lock();
            try {
                boolean flag = this.condition.await(5L, TimeUnit.MILLISECONDS);
                if (!flag) continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

