/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.handler;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdklog.logging.api.context.WorkerContext;
import org.jdklog.logging.api.monitor.Monitor;
import org.jdklog.logging.core.context.StudyThreadImpl;

public class ThreadMonitor
implements Monitor {
    private static final Logger LOGGER = Logger.getLogger(ThreadMonitor.class.toString());
    private final Map<String, Thread> threads = new WeakHashMap<String, Thread>(32);
    private final long blockTime;
    private ScheduledFuture<?> scheduledFuture;

    public ThreadMonitor(long blockTimeParam) {
        this.blockTime = blockTimeParam;
    }

    public final void registerThread(Thread thread) {
        String name = thread.getName();
        this.threads.put(name, thread);
    }

    public final void monitor(WorkerContext context) {
        ScheduledExecutorService scheduledExecutorService = context.getScheduledExecutorService();
        Runnable runnable = () -> {
            try {
                this.execute();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "\u5b9a\u65f6\u7ebf\u7a0b\u8fd0\u884c\u5f02\u5e38?\u5806\u6808\u4fe1\u606f:", e);
            }
        };
        this.scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(runnable, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    private void execute() {
        String name = ThreadMonitor.class.getName();
        long currentTimeMillis = System.currentTimeMillis();
        for (Map.Entry<String, Thread> entry : this.threads.entrySet()) {
            StackTraceElement[] stackTraces;
            boolean isMaxExecTime;
            StudyThreadImpl studyThread = (StudyThreadImpl)((Object)entry.getValue());
            long execStart = studyThread.startTime();
            long duration = currentTimeMillis - execStart;
            long maxExecTime = studyThread.maxExecTime();
            boolean isExecStart = 0L == execStart;
            boolean bl = isMaxExecTime = duration < maxExecTime;
            if (isExecStart || isMaxExecTime) {
                LOGGER.logp(Level.SEVERE, name, "execute0", "\u7ebf\u7a0b\u8fd0\u884c\u6b63\u5e38.");
                continue;
            }
            if (duration <= this.blockTime) {
                LOGGER.logp(Level.SEVERE, name, "execute1", "\u7ebf\u7a0b{0}", studyThread);
                LOGGER.logp(Level.SEVERE, name, "execute2", "\u9501\u5b9a{0}\u6beb\u79d2", duration);
                LOGGER.logp(Level.SEVERE, name, "execute3", "\u9650\u5236{0}\u6beb\u79d2", maxExecTime);
                continue;
            }
            for (StackTraceElement stackTrace : stackTraces = studyThread.getStackTrace()) {
                LOGGER.logp(Level.SEVERE, name, "execute4", "\u7ebf\u7a0b\u8fd0\u884c\u5f02\u5e38?\u5806\u6808\u4fe1\u606f:{0}", stackTrace);
            }
        }
    }

    public final void close() {
        if (null != this.scheduledFuture) {
            this.scheduledFuture.cancel(true);
        }
    }
}

