/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.manager;

import java.util.ArrayList;
import java.util.List;
import org.jdklog.logging.api.filter.Filter;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.manager.LogManager;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.api.metainfo.LogRecord;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.core.logger.ConfigurationData;
import org.jdklog.logging.core.logger.ConfigurationDataImpl;
import org.jdklog.logging.core.manager.AbstractLogManager;

public abstract class AbstractJuliLogger
implements Logger {
    private static final int OFF_VALUE = LogLevel.OFF.intValue();
    protected static final Handler[] EMPTY_HANDLERS = new Handler[0];
    protected static final LogManager MANAGER = AbstractLogManager.getLogManager();
    protected static final Level LEVEL1 = LogLevel.ALL;
    protected final ConfigurationDataImpl config;
    protected final String name;
    protected Logger parent;
    protected Logger next;
    protected Logger previous;
    protected int levelName;
    protected int levelValue1;
    protected final List<Handler> handlers1 = new ArrayList<Handler>(16);
    protected final List<Filter> filters1 = new ArrayList<Filter>(16);
    protected boolean isInherit;

    protected AbstractJuliLogger(String name) {
        this.config = new ConfigurationData();
        this.name = name;
    }

    private void sendLog(Record logRecord) {
        List<Handler> handlers = this.config.getHandlers();
        for (Handler handler : handlers) {
            handler.publish(logRecord);
        }
    }

    private void log(Level logLevel, String msg) {
        LogRecord lr = new LogRecord(logLevel, msg);
        this.doLog((Record)lr);
    }

    private void log(Record logRecord) {
        boolean isFilter;
        Level level = logRecord.getLevel();
        boolean isLoggableBySystem = this.isLoggable(level);
        boolean bl = isFilter = null != this.config.getFilter();
        if (!isFilter || this.config.isLoggable(logRecord)) {
            // empty if block
        }
        if (isLoggableBySystem) {
            this.sendLog(logRecord);
        }
    }

    public final void log(Level logLevel, String msg, Object param1) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setParameter(param1);
        this.doLog((Record)lr);
    }

    public final void log(Level logLevel, String msg, Object ... params) {
        LogRecord lr = new LogRecord(logLevel, msg);
        for (Object param : params) {
            lr.setParameter(param);
        }
        this.doLog((Record)lr);
    }

    public final void log(Level logLevel, String msg, Throwable thrown) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setThrown(thrown);
        this.doLog((Record)lr);
    }

    protected final void doLog(Record lr) {
        lr.setLoggerName(this.name);
        this.log(lr);
    }

    private boolean isLoggable(Level logLevel) {
        int levelValue = this.config.getLevelValue();
        boolean isIntValue = logLevel.intValue() >= levelValue;
        boolean isLevelValue = levelValue != OFF_VALUE;
        return isIntValue && isLevelValue;
    }

    public final void severe(String msg) {
        this.log(LogLevel.SEVERE, msg);
    }

    public final void warning(String msg) {
        this.log(LogLevel.WARNING, msg);
    }

    public final void info(String msg) {
        this.log(LogLevel.INFO, msg);
    }

    public final void config(String msg) {
        this.log(LogLevel.CONFIG, msg);
    }

    public final void fine(String msg) {
        this.log(LogLevel.FINE, msg);
    }

    public final void finer(String msg) {
        this.log(LogLevel.FINER, msg);
    }

    public final void finest(String msg) {
        this.log(LogLevel.FINEST, msg);
    }
}

