/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.manager;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.manager.LoaderLogInfo;
import org.jdklog.logging.api.manager.LogManager;
import org.jdklog.logging.core.utils.ClassLoadingUtils;

public abstract class AbstractLogManager
implements LogManager {
    private static final LogManager LOGMANAGER;
    private static final Map<ClassLoader, LoaderLogInfo> CLASSLOADERLOGGERS;

    public static LogManager getLogManager() {
        return LOGMANAGER;
    }

    public final void readConfiguration(InputStream ins) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void reset() {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void updateConfiguration(Function<String, BiFunction<String, String, String>> mapper) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void updateConfiguration(InputStream ins, Function<String, BiFunction<String, String, String>> mapper) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void checkAccess() {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void addConfigurationListener(Runnable listener) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void removeConfigurationListener(Runnable listener) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public final void checkPermission() {
    }

    public final Logger demandLogger(String name) {
        return this.getLogger(name);
    }

    public final Map<ClassLoader, LoaderLogInfo> getClassLoaderLoggers() {
        return Collections.unmodifiableMap(CLASSLOADERLOGGERS);
    }

    public static Map<ClassLoader, LoaderLogInfo> getClassLoaderLoggers1() {
        return Collections.unmodifiableMap(CLASSLOADERLOGGERS);
    }

    public final void put(ClassLoader classLoader, LoaderLogInfo info) {
        CLASSLOADERLOGGERS.put(classLoader, info);
    }

    public final void put(String loggerName, Logger logger) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        LoaderLogInfo temp = CLASSLOADERLOGGERS.get(classLoader);
        temp.put(loggerName, logger);
    }

    public final LoaderLogInfo get(ClassLoader current) {
        return CLASSLOADERLOGGERS.get(current);
    }

    public final Logger getRootLogger() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        LoaderLogInfo temp = CLASSLOADERLOGGERS.get(classLoader);
        return temp.getRootLogger();
    }

    public final Logger getLogger1(String name) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        LoaderLogInfo temp = CLASSLOADERLOGGERS.get(classLoader);
        return temp.get(name);
    }

    public final boolean containsKey(String loggerName) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        LoaderLogInfo temp = CLASSLOADERLOGGERS.get(classLoader);
        return temp.containsKey(loggerName);
    }

    public final String getProperty(String name) {
        return this.findProperty(name);
    }

    public final String findProperty(String name) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        LoaderLogInfo temp = CLASSLOADERLOGGERS.get(classLoader);
        return temp.getProperty(name);
    }

    public static String getProperty1(String name) {
        return LOGMANAGER.getProperty(name);
    }

    public final Handler[] getHandlers(String loggerName) {
        Logger logger1 = this.getLogger1(loggerName);
        return logger1.getHandlers();
    }

    static {
        CLASSLOADERLOGGERS = new HashMap<ClassLoader, LoaderLogInfo>(10);
        String logManagerName = System.getProperty("org.jdklog.logging.core.manager", "org.jdklog.logging.core.manager.StudyJuliLogManager");
        Constructor<?> constructor = ClassLoadingUtils.constructor(logManagerName);
        LOGMANAGER = (LogManager)ClassLoadingUtils.newInstance(constructor);
        LOGMANAGER.readConfiguration();
    }
}

