/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.manager.LoaderLogInfo;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.core.manager.JuliLogger;

public class ClassLoaderLogInfo
implements LoaderLogInfo {
    private final Logger rootLogger = new JuliLogger("RootLogger");
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>(1000);
    private final Map<String, Handler> handlers = new HashMap<String, Handler>(32);
    private final Properties props = new Properties();

    public final void addHandler(Handler handler) {
        this.rootLogger.addHandler(handler);
    }

    public final void setLevel(String levelName) {
        Level level = LogLevel.findLevel((String)levelName);
        this.rootLogger.setLevel(level);
    }

    public final Logger getRootLogger() {
        return this.rootLogger;
    }

    public final Map<String, Handler> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public final void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public final String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public final String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public final void load(InputStream inputStream) throws IOException {
        this.props.load(inputStream);
    }

    public final boolean isEmpty() {
        return this.props.isEmpty();
    }

    public final boolean containsKey(String loggerName) {
        return this.loggers.containsKey(loggerName);
    }

    public final Logger get(String name) {
        return this.loggers.get(name);
    }

    public final void put(String name, Logger logger) {
        this.loggers.put(name, logger);
    }

    public final void putIfAbsent(String handlerName, Handler handler) {
        this.handlers.putIfAbsent(handlerName, handler);
    }

    public final Handler getHandler(String handlerName) {
        return this.handlers.get(handlerName);
    }
}

