/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.manager;

import java.util.List;
import java.util.Objects;
import org.jdklog.logging.api.filter.Filter;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogRecord;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.core.manager.AbstractJuliLogger;

public class JuliLogger
extends AbstractJuliLogger {
    protected JuliLogger(String name) {
        super(name);
    }

    public static Logger getLogger(String name) {
        Logger result = MANAGER.demandLogger(name);
        if (null == result) {
            JuliLogger newLogger = new JuliLogger(name);
            do {
                if (!MANAGER.addLogger((Logger)newLogger)) continue;
                return newLogger;
            } while (null == (result = MANAGER.getLogger(name)));
        }
        return result;
    }

    public final Filter getFilter() {
        return this.config.getFilter();
    }

    public final void setFilter(Filter newFilter) {
        this.config.setFilter(newFilter);
    }

    public final void logp(Level logLevel, String sourceClass, String sourceMethod, String msg) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog((Record)lr);
    }

    public final void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Object param1) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameter(param1);
        lr.setUniqueId("-");
        this.doLog((Record)lr);
    }

    public final void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Object ... params) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        for (Object param : params) {
            lr.setParameter(param);
        }
        lr.setUniqueId("-");
        this.doLog((Record)lr);
    }

    public final void logp(Record lr) {
        this.doLog(lr);
    }

    public final void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        LogRecord lr = new LogRecord(logLevel, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog((Record)lr);
    }

    public final boolean isLevelInitialized() {
        return null != this.config.getLevelObject();
    }

    public final Level getLevel() {
        return this.config.getLevelObject();
    }

    public final void setLevel(Level newLogLevel) {
        this.config.setLevelObject(newLogLevel);
        int i = newLogLevel.intValue();
        this.config.setLevelValue(i);
    }

    public final String getName() {
        return this.name;
    }

    public final void addHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.config.addHandler(handler);
    }

    public final void removeHandler(Handler handler) {
        if (null == handler) {
            return;
        }
        this.config.removeHandler(handler);
    }

    public final Handler[] getHandlers() {
        return this.accessCheckedHandlers();
    }

    public final Handler[] accessCheckedHandlers() {
        List<Handler> handlers = this.config.getHandlers();
        return handlers.toArray(EMPTY_HANDLERS);
    }

    public final void setUseParentHandlers(boolean useParentHandlers) {
        this.config.setUseParentHandlers(useParentHandlers);
    }

    public final boolean hasUseParentHandlers() {
        return this.config.isUseParentHandlers();
    }

    public final Logger getParent() {
        return this.parent;
    }

    public final void setParent(Logger parent) {
        this.doSetParent(parent);
    }

    private void doSetParent(Logger newParent) {
        this.parent = newParent;
    }
}

