/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.manager;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdklog.logging.api.exception.StudyJuliRuntimeException;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.manager.LoaderLogInfo;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.core.manager.AbstractLogManager;
import org.jdklog.logging.core.manager.ClassLoaderLogInfo;
import org.jdklog.logging.core.utils.ClassLoadingUtils;

public final class StudyJuliLogManager
extends AbstractLogManager {
    private static final Lock CONFIGURATIONLOCK = new ReentrantLock();

    public boolean addLogger(Logger logger) {
        String loggerName = logger.getName();
        String packageName = "";
        int dotIndex = loggerName.lastIndexOf(46);
        if (0 <= dotIndex) {
            packageName = loggerName.substring(0, dotIndex);
        }
        if (this.containsKey(loggerName)) {
            return false;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        boolean extracted = this.isExtracted(logger, classLoader, loggerName);
        if (extracted) {
            this.put(loggerName, logger);
        } else if (this.containsKey(packageName)) {
            this.extracted(logger, loggerName, packageName);
        } else {
            boolean extracted1 = this.isExtracted(logger, classLoader, packageName);
            if (extracted1) {
                this.put(packageName, logger);
            } else {
                this.extracted(logger, loggerName);
            }
        }
        return true;
    }

    private void extracted(Logger logger, String loggerName, String packageName) {
        Handler[] handlers;
        Logger packageNameLogger = this.getLogger1(packageName);
        for (Handler h : handlers = packageNameLogger.getHandlers()) {
            logger.addHandler(h);
        }
        Level level = packageNameLogger.getLevel();
        logger.setLevel(level);
        this.put(loggerName, logger);
    }

    private void extracted(Logger logger, String loggerName) {
        Logger rootLogger = this.getLogger1("");
        if (null != rootLogger) {
            Handler[] rootHandlers;
            for (Handler rootHandler : rootHandlers = rootLogger.getHandlers()) {
                logger.addHandler(rootHandler);
            }
            Level level = rootLogger.getLevel();
            logger.setLevel(level);
        } else {
            Handler[] rootHandlers;
            Logger rootLogger1 = this.getRootLogger();
            for (Handler rootHandler : rootHandlers = rootLogger1.getHandlers()) {
                logger.addHandler(rootHandler);
            }
            Logger rootLogger2 = this.getRootLogger();
            Level level = rootLogger2.getLevel();
            logger.setLevel(level);
        }
        this.put(loggerName, logger);
    }

    private boolean isExtracted(Logger logger, ClassLoader classLoader, String loggerName) {
        Level level;
        String levelString = this.getProperty(loggerName + ".level");
        boolean isLevelString = Objects.nonNull(levelString);
        if (isLevelString) {
            String trim = levelString.trim();
            level = LogLevel.findLevel((String)trim);
            logger.setLevel(level);
        } else {
            Logger rootLogger = this.getRootLogger();
            level = rootLogger.getLevel();
            logger.setLevel(level);
        }
        String handlers = this.getProperty(loggerName + ".handlers");
        if (null != handlers) {
            logger.setUseParentHandlers(false);
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                String handlerName = tok.nextToken().trim();
                LoaderLogInfo info = this.get(classLoader);
                Handler handler = info.getHandler(handlerName);
                if (null == handler) continue;
                logger.addHandler(handler);
            }
            return true;
        }
        return false;
    }

    public Logger getLogger(String name) {
        return this.getLogger1(name);
    }

    public void readConfiguration() {
        String configFileStr = System.getProperty("org.jdklog.logging.core.config.file");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = new ClassLoaderLogInfo();
        this.put(classLoader, info);
        if (null == configFileStr) {
            info.setProperty(".level", "ALL");
            info.setProperty(".handlers", "org.jdklog.logging.core.handler.FileHandler");
        } else {
            File file = new File(configFileStr);
            Path target = file.toPath();
            CONFIGURATIONLOCK.lock();
            try (InputStream inputStream = Files.newInputStream(target, new OpenOption[0]);){
                info.load(inputStream);
            }
            catch (Exception e) {
                throw new StudyJuliRuntimeException("\u81ea\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5f02\u5e38.", (Throwable)e);
            }
            finally {
                CONFIGURATIONLOCK.unlock();
            }
        }
        String level = info.getProperty(".level");
        info.setLevel(level);
        String rootHandlers = info.getProperty(".handlers");
        StudyJuliLogManager.handler(info, rootHandlers, true);
        String handlers = info.getProperty("handlers");
        StudyJuliLogManager.handler(info, handlers, false);
    }

    private static void handler(LoaderLogInfo info, String handlers, boolean flag) {
        if (null != handlers) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                String handlerName = tok.nextToken().trim();
                Handler handler = StudyJuliLogManager.registerHandler(info, handlerName);
                if (!flag) continue;
                info.addHandler(handler);
            }
        }
    }

    private static Handler registerHandler(LoaderLogInfo info, String handlerName) {
        int pos;
        String handlerClassName = handlerName;
        String prefixTem = "study_juli.";
        char c = handlerClassName.charAt(0);
        if (Character.isDigit(c) && 0 <= (pos = handlerClassName.indexOf(46))) {
            prefixTem = handlerClassName.substring(0, pos + 1);
            handlerClassName = handlerClassName.substring(pos + 1);
        }
        try {
            Constructor<?> constructor = ClassLoadingUtils.constructor2(handlerClassName);
            Handler handler = (Handler)ClassLoadingUtils.newInstance(constructor, prefixTem);
            info.putIfAbsent(handlerName, handler);
            return handler;
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException("\u521d\u59cb\u5316handler\u5f02\u5e38.", (Throwable)e);
        }
    }
}

