/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.queue;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jdklog.logging.api.queue.StudyQueue;

public abstract class AbstractQueue<T>
implements StudyQueue<T> {
    private final LinkedBlockingDeque<T> queue;
    private int capacity = 5000;

    protected AbstractQueue() {
        this.queue = new LinkedBlockingDeque(this.capacity);
    }

    protected AbstractQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LinkedBlockingDeque(capacity);
    }

    public final T poll() {
        return this.queue.poll();
    }

    public final void enqueue(T logRecord) {
        try {
            this.queue.put(logRecord);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public final boolean isEnqueue(T t, long timeout) {
        boolean isSuccess = false;
        try {
            isSuccess = this.queue.offer(t, timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return isSuccess;
    }

    public final int size() {
        return this.queue.size();
    }
}

