/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.strategy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jdklog.logging.api.exception.StudyJuliRuntimeException;
import org.jdklog.logging.core.strategy.AbstractCompressStrategy;
import org.jdklog.logging.core.strategy.GzipOutputStreamByLevel;

public class GzipCompressStrategy
extends AbstractCompressStrategy {
    private static final int BUF_SIZE = 1024;

    public final void execute(File source, File destination) {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(destination);
             GzipOutputStreamByLevel gzipOut = new GzipOutputStreamByLevel((OutputStream)fos, 1024, 1);
             BufferedOutputStream os = new BufferedOutputStream(gzipOut, 1024);){
            int n;
            byte[] buff = new byte[1024];
            while (-1 != (n = fis.read(buff))) {
                ((OutputStream)os).write(buff, 0, n);
            }
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
    }

    public void execute() {
    }
}

