/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jdklog.logging.api.exception.StudyJuliRuntimeException;

public final class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static Constructor<?> constructor(String className) {
        ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> classObj = systemClassLoader.loadClass(className);
            return classObj.getConstructor(new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new StudyJuliRuntimeException("\u6784\u9020\u51fd\u6570\u53cd\u5c04\u5f02\u5e38.", (Throwable)e);
        }
    }

    public static Constructor<?> constructor2(String className) {
        ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> classObj = systemClassLoader.loadClass(className);
            return classObj.getConstructor(String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new StudyJuliRuntimeException("\u6784\u9020\u51fd\u6570\u53cd\u5c04\u5f02\u5e38.", (Throwable)e);
        }
    }

    public static Object newInstance(Constructor<?> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new StudyJuliRuntimeException("\u6784\u9020\u51fd\u6570\u53cd\u5c04\u52a8\u6001\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38.", (Throwable)e);
        }
    }

    public static Object newInstance(Constructor<?> constructor, String param) {
        try {
            return constructor.newInstance(param);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new StudyJuliRuntimeException("\u6784\u9020\u51fd\u6570\u53cd\u5c04\u52a8\u6001\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38.", (Throwable)e);
        }
    }
}

