/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.utils;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdklog.logging.api.strategy.Strategy;
import org.jdklog.logging.core.strategy.DeleteStrategy;
import org.jdklog.logging.core.strategy.GzipCompressStrategy;

public final class FileUtils {
    private static final Strategy GZIPCOMPRESSSTRATEGY = new GzipCompressStrategy();
    private static final LinkedHashMap<String, File> LOGFILES = new LinkedHashMap(16);

    private FileUtils() {
    }

    public static void strategy() {
        int size = LOGFILES.size();
        if (5 < size) {
            int temp = size - 5;
            Set<Map.Entry<String, File>> entries = LOGFILES.entrySet();
            Iterator<Map.Entry<String, File>> iterator = entries.iterator();
            for (int i = 0; i < temp; ++i) {
                Map.Entry<String, File> next = iterator.next();
                FileUtils.execute(next);
            }
        }
    }

    public static void execute(Map.Entry<String, File> next) {
        String key = next.getKey();
        File source = LOGFILES.get(key);
        String path = source.getAbsolutePath();
        String filePath = path + ".gz";
        File destination = new File(filePath);
        GZIPCOMPRESSSTRATEGY.execute(source, destination);
        DeleteStrategy.delete(source);
        LOGFILES.remove(key);
    }

    public static void putIfAbsent(String logFileName, File file) {
        LOGFILES.putIfAbsent(logFileName, file);
    }
}

