/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.dtaus.test;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.AlphaNumericText27;
import org.jdtaus.banking.Bankleitzahl;
import org.jdtaus.banking.Kontonummer;
import org.jdtaus.banking.Referenznummer10;
import org.jdtaus.banking.dtaus.Header;
import org.jdtaus.banking.dtaus.LogicalFileType;

public class HeaderTest
extends TestCase {
    public static Header getIllegalHeader() {
        return new Header();
    }

    public static Header getLegalHeader() throws ParseException {
        Header legal = new Header();
        legal.setAccount(Kontonummer.valueOf((Number)new Long(1111111111L)));
        legal.setBank(Bankleitzahl.valueOf((Number)new Integer(11111111)));
        legal.setBankData(Bankleitzahl.valueOf((Number)new Integer(11111111)));
        legal.setCurrency(Currency.getInstance("EUR"));
        legal.setCustomer(AlphaNumericText27.parse((String)"TEST                       "));
        legal.setReference(Referenznummer10.valueOf((Number)new Long(2222222222L)));
        legal.setCreateDate(new Date());
        legal.setType(LogicalFileType.LB);
        return legal;
    }

    public void testObject() throws Exception {
        Header h1 = new Header();
        Header h2 = new Header();
        Date createDate = new Date();
        Date executionDate = new Date();
        System.out.println(h1.toString());
        System.out.println(h2.toString());
        Assert.assertEquals((Object)h1, (Object)h2);
        Assert.assertEquals((Object)h2, (Object)h1);
        Assert.assertEquals((int)h1.hashCode(), (int)h2.hashCode());
        Assert.assertEquals((Object)h1, (Object)h1.clone());
        Assert.assertEquals((Object)h2, (Object)h2.clone());
        h1.setAccount(Kontonummer.valueOf((Number)new Integer(123)));
        h1.setBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        h1.setBankData(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        h1.setCurrency(Currency.getInstance("EUR"));
        h1.setCustomer(AlphaNumericText27.parse((String)"TEST 1                     "));
        h1.setReference(Referenznummer10.valueOf((Number)new Integer(123)));
        h1.setCreateDate(createDate);
        h1.setExecutionDate(executionDate);
        h2.setAccount(Kontonummer.valueOf((Number)new Integer(123)));
        h2.setBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        h2.setBankData(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        h2.setCurrency(Currency.getInstance("EUR"));
        h2.setCustomer(AlphaNumericText27.parse((String)"TEST 1                     "));
        h2.setReference(Referenznummer10.valueOf((Number)new Integer(123)));
        h2.setCreateDate(createDate);
        h2.setExecutionDate(executionDate);
        Assert.assertEquals((Object)h1, (Object)h2);
        Assert.assertEquals((Object)h2, (Object)h1);
        Assert.assertEquals((int)h1.hashCode(), (int)h2.hashCode());
        Assert.assertEquals((Object)h1, (Object)h1.clone());
        Assert.assertEquals((Object)h2, (Object)h2.clone());
        System.out.println(h1.toString());
        System.out.println(h2.toString());
        Assert.assertFalse((boolean)h1.equals((Object)HeaderTest.getIllegalHeader()));
        Assert.assertFalse((boolean)h1.equals((Object)HeaderTest.getLegalHeader()));
        Assert.assertFalse((boolean)h2.equals((Object)HeaderTest.getIllegalHeader()));
        Assert.assertFalse((boolean)h2.equals((Object)HeaderTest.getLegalHeader()));
        Assert.assertFalse((h1.hashCode() == HeaderTest.getIllegalHeader().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((h1.hashCode() == HeaderTest.getLegalHeader().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((h2.hashCode() == HeaderTest.getIllegalHeader().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((h2.hashCode() == HeaderTest.getLegalHeader().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((h1 == h1.clone() ? 1 : 0) != 0);
        Assert.assertFalse((h2 == h2.clone() ? 1 : 0) != 0);
        h1 = HeaderTest.getLegalHeader();
        h2 = HeaderTest.getLegalHeader();
        Assert.assertEquals((Object)h1, (Object)h2);
        Assert.assertEquals((int)h1.hashCode(), (int)h2.hashCode());
        h2.setAccount(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setBank(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setBankData(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setCurrency(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setCustomer(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setReference(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setCreateDate(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setExecutionDate(new Date());
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
        h2 = HeaderTest.getLegalHeader();
        h2.setType(null);
        Assert.assertFalse((boolean)h1.equals((Object)h2));
        Assert.assertFalse((h1.hashCode() == h2.hashCode() ? 1 : 0) != 0);
    }

    public void testDeprecations() throws Exception {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        Header legal = HeaderTest.getLegalHeader();
        Header.Schedule sched = legal.getSchedule();
        cal.add(5, 15);
        Date then = cal.getTime();
        cal.add(5, -60);
        Date before = cal.getTime();
        Assert.assertEquals((Object)legal.getCreateDate(), (Object)sched.getCreateDate());
        Assert.assertEquals((Object)legal.getExecutionDate(), (Object)sched.getExecutionDate());
        try {
            new Header.Schedule(null, null);
            throw new AssertionError();
        }
        catch (NullPointerException e) {
            try {
                new Header.Schedule(now, before);
                throw new AssertionError();
            }
            catch (IllegalArgumentException e2) {
                new Header.Schedule(now, null);
                new Header.Schedule(now, then);
                try {
                    new Header.Schedule(then, now);
                    throw new AssertionError();
                }
                catch (IllegalArgumentException e3) {
                    return;
                }
            }
        }
    }
}

