/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.dtaus.test;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.AlphaNumericText27;
import org.jdtaus.banking.Bankleitzahl;
import org.jdtaus.banking.Kontonummer;
import org.jdtaus.banking.Referenznummer11;
import org.jdtaus.banking.Textschluessel;
import org.jdtaus.banking.dtaus.Transaction;

public class TransactionTest
extends TestCase {
    public static final Textschluessel TEST_KEY = new TestTextschluessel(4, 0, true, false);

    public static Transaction getIllegalTransaction() {
        return new Transaction();
    }

    public static Transaction getLegalTransaction() throws ParseException {
        Transaction legal = new Transaction();
        AlphaNumericText27[] d = new AlphaNumericText27[]{AlphaNumericText27.parse((String)"DESCRIPTION 1              "), AlphaNumericText27.parse((String)"DESCRIPTION 2              "), AlphaNumericText27.parse((String)"DESCRIPTION 3              "), AlphaNumericText27.parse((String)"DESCRIPTION 4              "), AlphaNumericText27.parse((String)"DESCRIPTION 5              "), AlphaNumericText27.parse((String)"DESCRIPTION 6              "), AlphaNumericText27.parse((String)"DESCRIPTION 7              "), AlphaNumericText27.parse((String)"DESCRIPTION 8              "), AlphaNumericText27.parse((String)"DESCRIPTION 9              "), AlphaNumericText27.parse((String)"DESCRIPTION 10             "), AlphaNumericText27.parse((String)"DESCRIPTION 11             "), AlphaNumericText27.parse((String)"DESCRIPTION 12             "), AlphaNumericText27.parse((String)"DESCRIPTION 13             "), AlphaNumericText27.parse((String)"DESCRIPTION 14             ")};
        legal.setAmount(new BigInteger("100"));
        legal.setCurrency(Currency.getInstance("EUR"));
        legal.setDescriptions(d);
        legal.setExecutiveAccount(Kontonummer.valueOf((Number)new Long(1111111111L)));
        legal.setExecutiveBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        legal.setExecutiveExt(AlphaNumericText27.parse((String)"TEST                       "));
        legal.setExecutiveName(AlphaNumericText27.parse((String)"TEST                       "));
        legal.setPrimaryBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        legal.setReference(Referenznummer11.valueOf((Number)new Long(11111111111L)));
        legal.setTargetAccount(Kontonummer.valueOf((Number)new Long(1111111111L)));
        legal.setTargetBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        legal.setTargetExt(AlphaNumericText27.parse((String)"TEST                       "));
        legal.setTargetName(AlphaNumericText27.parse((String)"TEST                       "));
        legal.setType(TEST_KEY);
        return legal;
    }

    public void testObject() throws Exception {
        Transaction t1 = new Transaction();
        Transaction t2 = new Transaction();
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((Object)t2, (Object)t1);
        Assert.assertEquals((int)t1.hashCode(), (int)t2.hashCode());
        Assert.assertEquals((Object)t1, (Object)t1.clone());
        Assert.assertEquals((Object)t2, (Object)t2.clone());
        System.out.println(t1.toString());
        System.out.println(t2.toString());
        t1.setAmount(new BigInteger("0"));
        t1.setCurrency(Currency.getInstance("EUR"));
        t1.setDescriptions(null);
        t1.setExecutiveAccount(Kontonummer.valueOf((Number)new Integer(1)));
        t1.setExecutiveBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t1.setExecutiveExt(AlphaNumericText27.parse((String)"TEST"));
        t1.setExecutiveName(AlphaNumericText27.parse((String)"TEST 2"));
        t1.setPrimaryBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t1.setReference(Referenznummer11.valueOf((Number)new Integer(123)));
        t1.setTargetAccount(Kontonummer.valueOf((Number)new Integer(123)));
        t1.setTargetBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t1.setTargetExt(AlphaNumericText27.parse((String)"TEST 3"));
        t1.setTargetName(AlphaNumericText27.parse((String)"TEST 4"));
        t2.setAmount(new BigInteger("0"));
        t2.setCurrency(Currency.getInstance("EUR"));
        t2.setDescriptions(null);
        t2.setExecutiveAccount(Kontonummer.valueOf((Number)new Integer(1)));
        t2.setExecutiveBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t2.setExecutiveExt(AlphaNumericText27.parse((String)"TEST"));
        t2.setExecutiveName(AlphaNumericText27.parse((String)"TEST 2"));
        t2.setPrimaryBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t2.setReference(Referenznummer11.valueOf((Number)new Integer(123)));
        t2.setTargetAccount(Kontonummer.valueOf((Number)new Integer(123)));
        t2.setTargetBank(Bankleitzahl.valueOf((Number)new Integer(45050001)));
        t2.setTargetExt(AlphaNumericText27.parse((String)"TEST 3"));
        t2.setTargetName(AlphaNumericText27.parse((String)"TEST 4"));
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((Object)t2, (Object)t1);
        Assert.assertEquals((int)t1.hashCode(), (int)t2.hashCode());
        Assert.assertEquals((Object)t1, (Object)t1.clone());
        Assert.assertEquals((Object)t2, (Object)t2.clone());
        System.out.println(t1.toString());
        System.out.println(t2.toString());
        Assert.assertFalse((boolean)t1.equals((Object)TransactionTest.getIllegalTransaction()));
        Assert.assertFalse((boolean)t1.equals((Object)TransactionTest.getLegalTransaction()));
        Assert.assertFalse((boolean)t2.equals((Object)TransactionTest.getIllegalTransaction()));
        Assert.assertFalse((boolean)t2.equals((Object)TransactionTest.getLegalTransaction()));
        Assert.assertFalse((t1.hashCode() == TransactionTest.getIllegalTransaction().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((t1.hashCode() == TransactionTest.getLegalTransaction().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((t2.hashCode() == TransactionTest.getIllegalTransaction().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((t2.hashCode() == TransactionTest.getLegalTransaction().hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((t1 == t1.clone() ? 1 : 0) != 0);
        Assert.assertFalse((t2 == t2.clone() ? 1 : 0) != 0);
        t1 = TransactionTest.getLegalTransaction();
        t2 = TransactionTest.getLegalTransaction();
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((int)t1.hashCode(), (int)t2.hashCode());
        t2.setAmount(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setCurrency(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setDescriptions(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setExecutiveAccount(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setExecutiveBank(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setExecutiveExt(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setExecutiveName(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setPrimaryBank(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setReference(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setTargetAccount(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setTargetBank(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setTargetExt(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setTargetName(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        t2 = TransactionTest.getLegalTransaction();
        t2.setType(null);
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        Assert.assertFalse((t1.hashCode() == t2.hashCode() ? 1 : 0) != 0);
    }

    public void testDeprecations() throws Exception {
        Transaction legal = TransactionTest.getLegalTransaction();
        Assert.assertTrue((legal.getDescription().getDescriptionCount() == 14 ? 1 : 0) != 0);
        legal.setDescriptions(null);
        Assert.assertTrue((legal.getDescription().getDescriptionCount() == 0 ? 1 : 0) != 0);
        legal.setDescription(null);
        Assert.assertTrue((legal.getDescriptions().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((legal.getDescription().getDescriptionCount() == 0 ? 1 : 0) != 0);
    }

    public static class TestTextschluessel
    extends Textschluessel {
        public TestTextschluessel(int key, int extension, boolean debit, boolean remittance) {
            this.setKey(key);
            this.setExtension(extension);
            this.setDebit(debit);
            this.setRemittance(remittance);
        }

        public String getShortDescription(Locale locale) {
            return "TEST";
        }
    }
}

