/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.AlphaNumericText27;

public class AlphaNumericText27Test
extends TestCase {
    private static final String VALID_PREFIX = "valid.";
    private static final String INVALID_PREFIX = "invalid.";

    protected String[] getValid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(VALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    protected String[] getInvalid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(INVALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    private Map getProperties() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("classLoader");
        }
        Properties ret = new Properties();
        ret.load(classLoader.getResourceAsStream("org/jdtaus/banking/test/AlphaNumericText27Test.properties"));
        return ret;
    }

    public void testCharSequence() throws Exception {
        AlphaNumericText27 txt1 = AlphaNumericText27.parse((String)"TEST");
        AlphaNumericText27 txt2 = AlphaNumericText27.parse((String)"");
        System.out.println(txt1.toString());
        System.out.println(txt2.toString());
        Assert.assertTrue((txt1.length() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((txt2.length() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt1.charAt(0) == 'T' ? 1 : 0) != 0);
        Assert.assertTrue((txt1.charAt(3) == 'T' ? 1 : 0) != 0);
        try {
            txt2.charAt(0);
            this.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testObject() throws Exception {
        AlphaNumericText27 txt1 = AlphaNumericText27.parse((String)"TEST");
        AlphaNumericText27 txt2 = AlphaNumericText27.parse((String)"TEST");
        AlphaNumericText27 txt3 = AlphaNumericText27.parse((String)"TEST");
        AlphaNumericText27 txt4 = AlphaNumericText27.parse((String)"");
        Assert.assertEquals((Object)txt1, (Object)txt2);
        Assert.assertEquals((Object)txt2, (Object)txt3);
        Assert.assertEquals((Object)txt3, (Object)txt1);
        Assert.assertEquals((int)txt1.hashCode(), (int)txt2.hashCode());
        Assert.assertEquals((int)txt2.hashCode(), (int)txt3.hashCode());
        Assert.assertEquals((int)txt3.hashCode(), (int)txt1.hashCode());
        Assert.assertFalse((boolean)txt1.equals((Object)txt4));
        Assert.assertFalse((txt1.hashCode() == txt4.hashCode() ? 1 : 0) != 0);
    }

    public void testComparable() throws Exception {
        AlphaNumericText27 txt1 = AlphaNumericText27.parse((String)"A");
        AlphaNumericText27 txt2 = AlphaNumericText27.parse((String)"B");
        AlphaNumericText27 txt3 = AlphaNumericText27.parse((String)"C");
        Assert.assertEquals((int)txt1.compareTo((Object)txt1), (int)0);
        Assert.assertEquals((int)txt2.compareTo((Object)txt2), (int)0);
        Assert.assertEquals((int)txt3.compareTo((Object)txt3), (int)0);
        Assert.assertTrue((txt1.compareTo((Object)txt2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt1.compareTo((Object)txt3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt2.compareTo((Object)txt1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt2.compareTo((Object)txt3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt3.compareTo((Object)txt1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt3.compareTo((Object)txt2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((txt1.compareTo(null) == 1 ? 1 : 0) != 0);
        ArrayList<AlphaNumericText27> sorted = new ArrayList<AlphaNumericText27>(4);
        sorted.add(txt1);
        sorted.add(txt2);
        sorted.add(txt3);
        sorted.add(null);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            AlphaNumericText27 txt = (AlphaNumericText27)it.next();
            System.out.println(txt != null ? txt.format() : "null");
        }
        try {
            txt1.compareTo(new Object());
            this.fail();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testIsEmpty() throws Exception {
        AlphaNumericText27 txt1 = AlphaNumericText27.parse((String)"");
        AlphaNumericText27 txt2 = AlphaNumericText27.parse((String)"           ");
        AlphaNumericText27 txt3 = AlphaNumericText27.parse((String)"  A    ");
        Assert.assertTrue((boolean)txt1.isEmpty());
        Assert.assertTrue((boolean)txt2.isEmpty());
        Assert.assertFalse((boolean)txt3.isEmpty());
    }

    public void testParse() throws Exception {
        int i;
        String[] valid = this.getValid();
        String[] invalid = this.getInvalid();
        for (i = valid.length - 1; i >= 0; --i) {
            AlphaNumericText27.parse((String)valid[i]);
        }
        for (i = invalid.length - 1; i >= 0; --i) {
            try {
                AlphaNumericText27.parse((String)invalid[i]);
                throw new IllegalStateException(invalid[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
    }
}

