/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.Bankleitzahl;

public class BankleitzahlTest
extends TestCase {
    private static final String VALID_PREFIX = "valid.";
    private static final String INVALID_PREFIX = "invalid.";

    protected String[] getValid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(VALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    protected String[] getInvalid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(INVALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    private Map getProperties() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("classLoader");
        }
        Properties ret = new Properties();
        ret.load(classLoader.getResourceAsStream("org/jdtaus/banking/test/BankleitzahlTest.properties"));
        return ret;
    }

    public void testObject() throws Exception {
        Bankleitzahl blz1 = Bankleitzahl.valueOf((Number)new Integer(45050001));
        Bankleitzahl blz2 = Bankleitzahl.valueOf((Number)new Integer(45050001));
        Bankleitzahl blz3 = Bankleitzahl.valueOf((Number)new Integer(45050001));
        Bankleitzahl blz4 = Bankleitzahl.valueOf((Number)new Integer(10000000));
        System.out.println(blz1.toString());
        System.out.println(blz2.toString());
        System.out.println(blz3.toString());
        System.out.println(blz4.toString());
        Assert.assertEquals((Object)blz1, (Object)blz2);
        Assert.assertEquals((Object)blz2, (Object)blz3);
        Assert.assertEquals((Object)blz3, (Object)blz1);
        Assert.assertEquals((int)blz1.hashCode(), (int)blz2.hashCode());
        Assert.assertEquals((int)blz2.hashCode(), (int)blz3.hashCode());
        Assert.assertEquals((int)blz3.hashCode(), (int)blz1.hashCode());
        Assert.assertFalse((boolean)blz1.equals((Object)blz4));
        Assert.assertFalse((blz1.hashCode() == blz4.hashCode() ? 1 : 0) != 0);
    }

    public void testComparable() throws Exception {
        Bankleitzahl blz1 = Bankleitzahl.valueOf((Number)new Integer(10000000));
        Bankleitzahl blz2 = Bankleitzahl.valueOf((Number)new Integer(10000001));
        Bankleitzahl blz3 = Bankleitzahl.valueOf((Number)new Integer(10000002));
        Assert.assertEquals((int)blz1.compareTo((Object)blz1), (int)0);
        Assert.assertEquals((int)blz2.compareTo((Object)blz2), (int)0);
        Assert.assertEquals((int)blz3.compareTo((Object)blz3), (int)0);
        Assert.assertEquals((int)blz1.compareTo((Object)blz2), (int)-1);
        Assert.assertEquals((int)blz1.compareTo((Object)blz3), (int)-1);
        Assert.assertEquals((int)blz2.compareTo((Object)blz1), (int)1);
        Assert.assertEquals((int)blz2.compareTo((Object)blz3), (int)-1);
        Assert.assertEquals((int)blz3.compareTo((Object)blz1), (int)1);
        Assert.assertEquals((int)blz3.compareTo((Object)blz2), (int)1);
        ArrayList<Bankleitzahl> sorted = new ArrayList<Bankleitzahl>(4);
        sorted.add(blz1);
        sorted.add(blz2);
        sorted.add(blz3);
        sorted.add(null);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            Bankleitzahl blz = (Bankleitzahl)it.next();
            System.out.println(blz == null ? "null" : blz.format(Bankleitzahl.ELECTRONIC_FORMAT) + '\t' + blz.format(Bankleitzahl.LETTER_FORMAT));
        }
        try {
            blz1.compareTo(new Object());
            this.fail();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testParse() throws Exception {
        int i;
        String[] valid = this.getValid();
        String[] invalid = this.getInvalid();
        for (i = valid.length - 1; i >= 0; --i) {
            Bankleitzahl.parse((String)valid[i]);
        }
        for (i = invalid.length - 1; i >= 0; --i) {
            try {
                Bankleitzahl.parse((String)invalid[i]);
                throw new IllegalStateException(invalid[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
    }
}

