/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.Kontonummer;

public class KontonummerTest
extends TestCase {
    private static final String VALID_PREFIX = "valid.";
    private static final String INVALID_PREFIX = "invalid.";

    protected String[] getValid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(VALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    protected String[] getInvalid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(INVALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    private Map getProperties() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("classLoader");
        }
        Properties ret = new Properties();
        ret.load(classLoader.getResourceAsStream("org/jdtaus/banking/test/KontonummerTest.properties"));
        return ret;
    }

    public void testObject() throws Exception {
        Kontonummer kto1 = Kontonummer.valueOf((Number)new Long(9999999999L));
        Kontonummer kto2 = Kontonummer.valueOf((Number)new Long(9999999999L));
        Kontonummer kto3 = Kontonummer.valueOf((Number)new Long(9999999999L));
        Kontonummer kto4 = Kontonummer.valueOf((Number)new Long(1111111111L));
        System.out.println(kto1.toString());
        System.out.println(kto2.toString());
        System.out.println(kto3.toString());
        System.out.println(kto4.toString());
        Assert.assertEquals((Object)kto1, (Object)kto2);
        Assert.assertEquals((Object)kto2, (Object)kto3);
        Assert.assertEquals((Object)kto3, (Object)kto1);
        Assert.assertEquals((int)kto1.hashCode(), (int)kto2.hashCode());
        Assert.assertEquals((int)kto2.hashCode(), (int)kto3.hashCode());
        Assert.assertEquals((int)kto3.hashCode(), (int)kto1.hashCode());
        Assert.assertFalse((boolean)kto1.equals((Object)kto4));
        Assert.assertFalse((kto1.hashCode() == kto4.hashCode() ? 1 : 0) != 0);
    }

    public void testComparable() throws Exception {
        Kontonummer kto1 = Kontonummer.valueOf((Number)new Long(1000000000L));
        Kontonummer kto2 = Kontonummer.valueOf((Number)new Long(1000000001L));
        Kontonummer kto3 = Kontonummer.valueOf((Number)new Long(1000000002L));
        Assert.assertEquals((int)kto1.compareTo((Object)kto1), (int)0);
        Assert.assertEquals((int)kto2.compareTo((Object)kto2), (int)0);
        Assert.assertEquals((int)kto3.compareTo((Object)kto3), (int)0);
        Assert.assertEquals((int)kto1.compareTo((Object)kto2), (int)-1);
        Assert.assertEquals((int)kto1.compareTo((Object)kto3), (int)-1);
        Assert.assertEquals((int)kto2.compareTo((Object)kto1), (int)1);
        Assert.assertEquals((int)kto2.compareTo((Object)kto3), (int)-1);
        Assert.assertEquals((int)kto3.compareTo((Object)kto1), (int)1);
        Assert.assertEquals((int)kto3.compareTo((Object)kto2), (int)1);
        ArrayList<Kontonummer> sorted = new ArrayList<Kontonummer>(4);
        sorted.add(kto1);
        sorted.add(kto2);
        sorted.add(kto3);
        sorted.add(null);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            Kontonummer kto = (Kontonummer)it.next();
            System.out.println(kto == null ? "null" : kto.format(Kontonummer.ELECTRONIC_FORMAT) + '\t' + kto.format(Kontonummer.LETTER_FORMAT));
        }
        try {
            kto1.compareTo(new Object());
            this.fail();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testParse() throws Exception {
        int i;
        String[] valid = this.getValid();
        String[] invalid = this.getInvalid();
        for (i = valid.length - 1; i >= 0; --i) {
            Kontonummer.parse((String)valid[i]);
        }
        for (i = invalid.length - 1; i >= 0; --i) {
            try {
                Kontonummer.parse((String)invalid[i]);
                throw new IllegalStateException(invalid[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
    }
}

