/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.Referenznummer10;

public class Referenznummer10Test
extends TestCase {
    private static final String VALID_PREFIX = "valid.";
    private static final String INVALID_PREFIX = "invalid.";

    protected String[] getValid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(VALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    protected String[] getInvalid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(INVALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    private Map getProperties() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("classLoader");
        }
        Properties ret = new Properties();
        ret.load(classLoader.getResourceAsStream("org/jdtaus/banking/test/Referenznummer10Test.properties"));
        return ret;
    }

    public void testObject() throws Exception {
        Referenznummer10 ref1 = Referenznummer10.valueOf((Number)new Long(9999999999L));
        Referenznummer10 ref2 = Referenznummer10.valueOf((Number)new Long(9999999999L));
        Referenznummer10 ref3 = Referenznummer10.valueOf((Number)new Long(9999999999L));
        Referenznummer10 ref4 = Referenznummer10.valueOf((Number)new Long(1111111111L));
        System.out.println(ref1.toString());
        System.out.println(ref2.toString());
        System.out.println(ref3.toString());
        System.out.println(ref4.toString());
        Assert.assertEquals((Object)ref1, (Object)ref2);
        Assert.assertEquals((Object)ref2, (Object)ref3);
        Assert.assertEquals((Object)ref3, (Object)ref1);
        Assert.assertEquals((int)ref1.hashCode(), (int)ref2.hashCode());
        Assert.assertEquals((int)ref2.hashCode(), (int)ref3.hashCode());
        Assert.assertEquals((int)ref3.hashCode(), (int)ref1.hashCode());
        Assert.assertFalse((boolean)ref1.equals((Object)ref4));
        Assert.assertFalse((ref1.hashCode() == ref4.hashCode() ? 1 : 0) != 0);
    }

    public void testComparable() throws Exception {
        Referenznummer10 ref1 = Referenznummer10.valueOf((Number)new Long(1000000000L));
        Referenznummer10 ref2 = Referenznummer10.valueOf((Number)new Long(1000000001L));
        Referenznummer10 ref3 = Referenznummer10.valueOf((Number)new Long(1000000002L));
        Referenznummer10 leadingZeroes1 = Referenznummer10.valueOf((Number)new Long(1L));
        Referenznummer10 leadingZeroes2 = Referenznummer10.valueOf((Number)new Long(11L));
        Referenznummer10 leadingZeroes3 = Referenznummer10.valueOf((Number)new Long(111L));
        Referenznummer10 leadingZeroes4 = Referenznummer10.valueOf((Number)new Long(1111L));
        Referenznummer10 leadingZeroes5 = Referenznummer10.valueOf((Number)new Long(11111L));
        Referenznummer10 leadingZeroes6 = Referenznummer10.valueOf((Number)new Long(111111L));
        Referenznummer10 leadingZeroes7 = Referenznummer10.valueOf((Number)new Long(1111111L));
        Referenznummer10 leadingZeroes8 = Referenznummer10.valueOf((Number)new Long(11111111L));
        Referenznummer10 leadingZeroes9 = Referenznummer10.valueOf((Number)new Long(111111111L));
        Referenznummer10 leadingZeroes10 = Referenznummer10.valueOf((Number)new Long(1111111111L));
        Assert.assertEquals((int)ref1.compareTo((Object)ref1), (int)0);
        Assert.assertEquals((int)ref2.compareTo((Object)ref2), (int)0);
        Assert.assertEquals((int)ref3.compareTo((Object)ref3), (int)0);
        Assert.assertEquals((int)ref1.compareTo((Object)ref2), (int)-1);
        Assert.assertEquals((int)ref1.compareTo((Object)ref3), (int)-1);
        Assert.assertEquals((int)ref2.compareTo((Object)ref1), (int)1);
        Assert.assertEquals((int)ref2.compareTo((Object)ref3), (int)-1);
        Assert.assertEquals((int)ref3.compareTo((Object)ref1), (int)1);
        Assert.assertEquals((int)ref3.compareTo((Object)ref2), (int)1);
        ArrayList<Referenznummer10> sorted = new ArrayList<Referenznummer10>(4);
        sorted.add(ref1);
        sorted.add(ref2);
        sorted.add(ref3);
        sorted.add(leadingZeroes1);
        sorted.add(leadingZeroes2);
        sorted.add(leadingZeroes3);
        sorted.add(leadingZeroes4);
        sorted.add(leadingZeroes5);
        sorted.add(leadingZeroes6);
        sorted.add(leadingZeroes7);
        sorted.add(leadingZeroes8);
        sorted.add(leadingZeroes9);
        sorted.add(leadingZeroes10);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            Referenznummer10 ref = (Referenznummer10)it.next();
            System.out.println(ref == null ? "null" : ref.format(Referenznummer10.ELECTRONIC_FORMAT) + '\t' + ref.format(Referenznummer10.LETTER_FORMAT));
        }
        try {
            ref1.compareTo(new Object());
            this.fail();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testParse() throws Exception {
        int i;
        String[] valid = this.getValid();
        String[] invalid = this.getInvalid();
        for (i = valid.length - 1; i >= 0; --i) {
            Referenznummer10.parse((String)valid[i]);
        }
        for (i = invalid.length - 1; i >= 0; --i) {
            try {
                Referenznummer10.parse((String)invalid[i]);
                throw new IllegalStateException(invalid[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
    }
}

