/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jdtaus.banking.Referenznummer11;

public class Referenznummer11Test
extends TestCase {
    private static final String VALID_PREFIX = "valid.";
    private static final String INVALID_PREFIX = "invalid.";

    protected String[] getValid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(VALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    protected String[] getInvalid() throws IOException {
        Map properties = this.getProperties();
        LinkedList col = new LinkedList();
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(INVALID_PREFIX)) continue;
            col.add(properties.get(key));
        }
        return col.toArray(new String[col.size()]);
    }

    private Map getProperties() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("classLoader");
        }
        Properties ret = new Properties();
        ret.load(classLoader.getResourceAsStream("org/jdtaus/banking/test/Referenznummer11Test.properties"));
        return ret;
    }

    public void testObject() throws Exception {
        Referenznummer11 ref1 = Referenznummer11.valueOf((Number)new Long(99999999999L));
        Referenznummer11 ref2 = Referenznummer11.valueOf((Number)new Long(99999999999L));
        Referenznummer11 ref3 = Referenznummer11.valueOf((Number)new Long(99999999999L));
        Referenznummer11 ref4 = Referenznummer11.valueOf((Number)new Long(11111111111L));
        System.out.println(ref1.toString());
        System.out.println(ref2.toString());
        System.out.println(ref3.toString());
        System.out.println(ref4.toString());
        Assert.assertEquals((Object)ref1, (Object)ref2);
        Assert.assertEquals((Object)ref2, (Object)ref3);
        Assert.assertEquals((Object)ref3, (Object)ref1);
        Assert.assertEquals((int)ref1.hashCode(), (int)ref2.hashCode());
        Assert.assertEquals((int)ref2.hashCode(), (int)ref3.hashCode());
        Assert.assertEquals((int)ref3.hashCode(), (int)ref1.hashCode());
        Assert.assertFalse((boolean)ref1.equals((Object)ref4));
        Assert.assertFalse((ref1.hashCode() == ref4.hashCode() ? 1 : 0) != 0);
    }

    public void testComparable() throws Exception {
        Referenznummer11 ref1 = Referenznummer11.valueOf((Number)new Long(10000000000L));
        Referenznummer11 ref2 = Referenznummer11.valueOf((Number)new Long(10000000001L));
        Referenznummer11 ref3 = Referenznummer11.valueOf((Number)new Long(10000000002L));
        Referenznummer11 leadingZeroes1 = Referenznummer11.valueOf((Number)new Long(1L));
        Referenznummer11 leadingZeroes2 = Referenznummer11.valueOf((Number)new Long(11L));
        Referenznummer11 leadingZeroes3 = Referenznummer11.valueOf((Number)new Long(111L));
        Referenznummer11 leadingZeroes4 = Referenznummer11.valueOf((Number)new Long(1111L));
        Referenznummer11 leadingZeroes5 = Referenznummer11.valueOf((Number)new Long(11111L));
        Referenznummer11 leadingZeroes6 = Referenznummer11.valueOf((Number)new Long(111111L));
        Referenznummer11 leadingZeroes7 = Referenznummer11.valueOf((Number)new Long(1111111L));
        Referenznummer11 leadingZeroes8 = Referenznummer11.valueOf((Number)new Long(11111111L));
        Referenznummer11 leadingZeroes9 = Referenznummer11.valueOf((Number)new Long(111111111L));
        Referenznummer11 leadingZeroes10 = Referenznummer11.valueOf((Number)new Long(1111111111L));
        Referenznummer11 leadingZeroes11 = Referenznummer11.valueOf((Number)new Long(11111111111L));
        Assert.assertEquals((int)ref1.compareTo((Object)ref1), (int)0);
        Assert.assertEquals((int)ref2.compareTo((Object)ref2), (int)0);
        Assert.assertEquals((int)ref3.compareTo((Object)ref3), (int)0);
        Assert.assertEquals((int)ref1.compareTo((Object)ref2), (int)-1);
        Assert.assertEquals((int)ref1.compareTo((Object)ref3), (int)-1);
        Assert.assertEquals((int)ref2.compareTo((Object)ref1), (int)1);
        Assert.assertEquals((int)ref2.compareTo((Object)ref3), (int)-1);
        Assert.assertEquals((int)ref3.compareTo((Object)ref1), (int)1);
        Assert.assertEquals((int)ref3.compareTo((Object)ref2), (int)1);
        ArrayList<Referenznummer11> sorted = new ArrayList<Referenznummer11>(4);
        sorted.add(ref1);
        sorted.add(ref2);
        sorted.add(ref3);
        sorted.add(leadingZeroes1);
        sorted.add(leadingZeroes2);
        sorted.add(leadingZeroes3);
        sorted.add(leadingZeroes4);
        sorted.add(leadingZeroes5);
        sorted.add(leadingZeroes6);
        sorted.add(leadingZeroes7);
        sorted.add(leadingZeroes8);
        sorted.add(leadingZeroes9);
        sorted.add(leadingZeroes10);
        sorted.add(leadingZeroes11);
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            Referenznummer11 ref = (Referenznummer11)it.next();
            System.out.println(ref == null ? "null" : ref.format(Referenznummer11.ELECTRONIC_FORMAT) + '\t' + ref.format(Referenznummer11.LETTER_FORMAT));
        }
        try {
            ref1.compareTo(new Object());
            this.fail();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testParse() throws Exception {
        int i;
        String[] valid = this.getValid();
        String[] invalid = this.getInvalid();
        for (i = valid.length - 1; i >= 0; --i) {
            Referenznummer11.parse((String)valid[i]);
        }
        for (i = invalid.length - 1; i >= 0; --i) {
            try {
                Referenznummer11.parse((String)invalid[i]);
                throw new IllegalStateException(invalid[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
    }
}

