/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AlphaNumericText27
implements CharSequence,
Comparable,
Serializable {
    private static final long serialVersionUID = -5231830564347967536L;
    private static volatile Reference cacheReference = new SoftReference<Object>(null);
    public static final int MAX_LENGTH = 27;
    private String text;
    private boolean empty;

    private AlphaNumericText27(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() > 27) {
            throw new IllegalArgumentException(text);
        }
        this.text = text;
        this.empty = text.trim().length() == 0;
    }

    public static AlphaNumericText27 parse(String text, ParsePosition pos) {
        int i;
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        boolean valid = true;
        AlphaNumericText27 ret = null;
        int beginIndex = pos.getIndex();
        int len = text.length();
        for (i = beginIndex; i < beginIndex + 27 && i < len; ++i) {
            if (AlphaNumericText27.checkAlphaNumeric(text.charAt(i))) continue;
            pos.setErrorIndex(i);
            valid = false;
            break;
        }
        if (valid) {
            pos.setIndex(i);
            ret = new AlphaNumericText27(text.substring(beginIndex, i));
        }
        return ret;
    }

    public static AlphaNumericText27 parse(String text) throws ParseException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        AlphaNumericText27 txt = (AlphaNumericText27)AlphaNumericText27.getCache().get(text);
        if (txt == null) {
            ParsePosition pos = new ParsePosition(0);
            txt = AlphaNumericText27.parse(text, pos);
            if (txt == null || pos.getErrorIndex() != -1 || pos.getIndex() < text.length()) {
                throw new ParseException(text, pos.getErrorIndex() != -1 ? pos.getErrorIndex() : pos.getIndex());
            }
            AlphaNumericText27.getCache().put(text, txt);
        }
        return txt;
    }

    public static AlphaNumericText27 valueOf(String text) {
        try {
            return AlphaNumericText27.parse(text);
        }
        catch (ParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(text).initCause(e);
        }
    }

    public StringBuffer format(StringBuffer toAppendTo) {
        if (toAppendTo == null) {
            throw new NullPointerException("toAppendTo");
        }
        return toAppendTo.append(this.text);
    }

    public String format() {
        return this.text;
    }

    public static String toString(AlphaNumericText27 alphaNumericText27) {
        if (alphaNumericText27 == null) {
            throw new NullPointerException("alphaNumericText27");
        }
        return alphaNumericText27.format();
    }

    public static boolean checkAlphaNumeric(char c) {
        return c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '+' || c == '*' || c == '$' || c == ' ' || c == ',' || c == '&' || c == '-' || c == '/' || c == '%' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc' || c == '\u00df';
    }

    public static String normalize(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        char[] ret = text.toCharArray();
        for (int i = ret.length - 1; i >= 0; --i) {
            if (Character.isLowerCase(ret[i])) {
                ret[i] = Character.toUpperCase(ret[i]);
            }
            if (AlphaNumericText27.checkAlphaNumeric(ret[i])) continue;
            ret[i] = 32;
        }
        return new String(ret);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private static Map getCache() {
        Map cache = (Map)cacheReference.get();
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap(1024));
            cacheReference = new SoftReference(cache);
        }
        return cache;
    }

    public int length() {
        return this.text.length();
    }

    public char charAt(int index) {
        return this.text.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.text.subSequence(start, end);
    }

    public String toString() {
        return this.text;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (!(o instanceof AlphaNumericText27)) {
            throw new ClassCastException(o.getClass().getName());
        }
        AlphaNumericText27 that = (AlphaNumericText27)o;
        int result = 0;
        if (!this.equals(o)) {
            result = this.text == null ? (that.text == null ? 0 : -1) : (that.text == null ? 1 : this.text.compareTo(that.text));
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = o == this;
        if (!ret && o instanceof AlphaNumericText27) {
            AlphaNumericText27 that = (AlphaNumericText27)o;
            ret = this.text == null ? that.text == null : this.text.equals(that.text);
        }
        return ret;
    }

    public int hashCode() {
        return this.text == null ? 0 : this.text.hashCode();
    }
}

