/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Bankleitzahl
extends Number
implements Comparable {
    public static final int ELECTRONIC_FORMAT = 3001;
    public static final int LETTER_FORMAT = 3002;
    public static final int MAX_DIGITS = 8;
    public static final int MAX_CHARACTERS = 10;
    private static final double[] EXP10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7};
    private static final long serialVersionUID = -3329406998979147668L;
    private static volatile Reference cacheReference = new SoftReference<Object>(null);
    private int blz;
    private int clearingArea;
    private int localityCode;
    private int networkCode;
    private int instituteCode;

    private Bankleitzahl(Number bankCode) {
        if (!Bankleitzahl.checkBankleitzahl(bankCode)) {
            throw new IllegalArgumentException(bankCode.toString());
        }
        int[] digits = Bankleitzahl.toDigits(bankCode.longValue());
        long lCode = bankCode.longValue();
        this.clearingArea = digits[7];
        this.localityCode = (int)Math.floor((double)lCode / EXP10[5]);
        this.networkCode = digits[4];
        this.instituteCode = (int)Math.floor((double)lCode - (double)digits[7] * EXP10[7] - (double)digits[6] * EXP10[6] - (double)digits[5] * EXP10[5] - (double)digits[4] * EXP10[4]);
        this.blz = bankCode.intValue();
    }

    public static Bankleitzahl parse(String bankCode, ParsePosition pos) {
        int i;
        if (bankCode == null) {
            throw new NullPointerException("bankCode");
        }
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        Bankleitzahl ret = null;
        boolean sawSpace = false;
        boolean failed = false;
        ParsePosition fmtPos = new ParsePosition(0);
        int len = bankCode.length();
        int startIndex = pos.getIndex();
        int maxIndex = startIndex + 10;
        StringBuffer digits = new StringBuffer(8);
        int mode = 3001;
        int part = 0;
        int partStart = 0;
        int partEnd = 2;
        int digit = 0;
        for (i = startIndex; i < len && i < maxIndex && digits.length() < 8; ++i) {
            char c = bankCode.charAt(i);
            if (Character.isDigit(c)) {
                sawSpace = false;
                if (mode == 3002) {
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    } else {
                        digits.append(c);
                    }
                } else {
                    digits.append(c);
                }
                ++digit;
            } else if (c == ' ') {
                if (sawSpace || i == startIndex || mode == 3001 && digit != 3) {
                    failed = true;
                } else {
                    mode = 3002;
                    switch (part) {
                        case 0: {
                            partStart = 3;
                            partEnd = 5;
                            break;
                        }
                        case 1: {
                            partStart = 6;
                            partEnd = 7;
                            break;
                        }
                        default: {
                            failed = true;
                        }
                    }
                    ++part;
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    }
                }
                sawSpace = true;
            } else {
                failed = true;
            }
            if (!failed) continue;
            pos.setErrorIndex(i);
            break;
        }
        if (!failed) {
            Number num = new DecimalFormat("########").parse(digits.toString(), fmtPos);
            if (num != null && fmtPos.getErrorIndex() == -1) {
                String key = num.toString();
                ret = (Bankleitzahl)Bankleitzahl.getCache().get(key);
                if (ret == null) {
                    if (!Bankleitzahl.checkBankleitzahl(num)) {
                        pos.setErrorIndex(startIndex);
                        ret = null;
                    } else {
                        pos.setIndex(i);
                        ret = new Bankleitzahl(num);
                        Bankleitzahl.getCache().put(key, ret);
                    }
                } else {
                    pos.setIndex(i);
                }
            } else {
                pos.setErrorIndex(startIndex);
            }
        }
        return ret;
    }

    public static Bankleitzahl parse(String bankCode) throws ParseException {
        if (bankCode == null) {
            throw new NullPointerException("bankCode");
        }
        Bankleitzahl blz = (Bankleitzahl)Bankleitzahl.getCache().get(bankCode);
        if (blz == null) {
            ParsePosition pos = new ParsePosition(0);
            blz = Bankleitzahl.parse(bankCode, pos);
            if (blz == null || pos.getErrorIndex() != -1 || pos.getIndex() < bankCode.length()) {
                throw new ParseException(bankCode, pos.getErrorIndex() != -1 ? pos.getErrorIndex() : pos.getIndex());
            }
            Bankleitzahl.getCache().put(bankCode, blz);
        }
        return blz;
    }

    public static Bankleitzahl valueOf(Number bankCode) {
        if (bankCode == null) {
            throw new NullPointerException("bankCode");
        }
        String key = bankCode.toString();
        Bankleitzahl ret = (Bankleitzahl)Bankleitzahl.getCache().get(key);
        if (ret == null) {
            ret = new Bankleitzahl(bankCode);
            Bankleitzahl.getCache().put(key, ret);
        }
        return ret;
    }

    public static Bankleitzahl valueOf(String bankCode) {
        try {
            return Bankleitzahl.parse(bankCode);
        }
        catch (ParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(bankCode).initCause(e);
        }
    }

    public static boolean checkBankleitzahl(Number bankCode) {
        boolean valid;
        boolean bl = valid = bankCode != null;
        if (valid) {
            long num = bankCode.longValue();
            boolean bl2 = valid = num > 0L && num < 100000000L;
            if (valid && num > 9999999L) {
                int[] digits = Bankleitzahl.toDigits(num);
                valid = digits[7] != 0 && digits[7] != 9;
            }
        }
        return valid;
    }

    public int intValue() {
        return this.blz;
    }

    public long longValue() {
        return this.blz;
    }

    public float floatValue() {
        return this.blz;
    }

    public double doubleValue() {
        return this.blz;
    }

    public boolean isClearingAreaCodeSupported() {
        return this.blz > 9999999;
    }

    public int getClearingArea() {
        return this.getClearingAreaCode();
    }

    public int getClearingAreaCode() {
        if (!this.isClearingAreaCodeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.clearingArea;
    }

    public boolean isLocalityCodeSupported() {
        return this.blz > 99999;
    }

    public int getLocalityCode() {
        if (!this.isLocalityCodeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.localityCode;
    }

    public boolean isNetworkCodeSupported() {
        return this.blz > 9999;
    }

    public int getNetworkCode() {
        if (!this.isNetworkCodeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.networkCode;
    }

    public int getInstituteCode() {
        return this.instituteCode;
    }

    public StringBuffer format(int style, StringBuffer toAppendTo) {
        if (toAppendTo == null) {
            throw new NullPointerException("toAppendTo");
        }
        if (style != 3001 && style != 3002) {
            throw new IllegalArgumentException(Integer.toString(style));
        }
        int[] digits = Bankleitzahl.toDigits(this.blz);
        int lastDigit = 0;
        for (int i = digits.length - 1; i >= 0; --i) {
            if (digits[i] != 0 || lastDigit > 0) {
                toAppendTo.append(digits[i]);
                ++lastDigit;
            }
            if (style != 3002 || lastDigit != 3 && lastDigit != 6) continue;
            toAppendTo.append(' ');
        }
        return toAppendTo;
    }

    public String format(int style) {
        return this.format(style, new StringBuffer()).toString();
    }

    public static String toString(Bankleitzahl bankleitzahl) {
        if (bankleitzahl == null) {
            throw new NullPointerException("bankleitzahl");
        }
        return bankleitzahl.format(3001);
    }

    private static int[] toDigits(long number) {
        int[] ret = new int[8];
        for (int i = 7; i >= 0; --i) {
            int subst = 0;
            for (int j = i + 1; j < 8; ++j) {
                subst = (int)((double)subst + (double)ret[j] * EXP10[j]);
            }
            ret[i] = (int)Math.floor((double)(number - (long)subst) / EXP10[i]);
        }
        return ret;
    }

    private String internalString() {
        return new StringBuffer(500).append('{').append("blz=").append(this.blz).append(", clearingAreaCodeSupported=").append(this.isClearingAreaCodeSupported()).append(", clearingArea=").append(this.clearingArea).append(", instituteCode=").append(this.instituteCode).append(", localityCodeSupported=").append(this.isLocalityCodeSupported()).append(", localityCode=").append(this.localityCode).append(", networkCodeSupported=").append(this.isNetworkCodeSupported()).append(", networkCode=").append(this.networkCode).append('}').toString();
    }

    private static Map getCache() {
        Map cache = (Map)cacheReference.get();
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap(1024));
            cacheReference = new SoftReference(cache);
        }
        return cache;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (!(o instanceof Bankleitzahl)) {
            throw new ClassCastException(o.getClass().getName());
        }
        int result = 0;
        Bankleitzahl that = (Bankleitzahl)o;
        if (!this.equals(that)) {
            result = this.blz > that.blz ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean equal;
        boolean bl = equal = o == this;
        if (!equal && o instanceof Bankleitzahl) {
            equal = this.blz == ((Bankleitzahl)o).blz;
        }
        return equal;
    }

    public int hashCode() {
        return this.blz;
    }

    public String toString() {
        return super.toString() + this.internalString();
    }
}

