/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Kontonummer
extends Number
implements Comparable {
    public static final int ELECTRONIC_FORMAT = 4001;
    public static final int LETTER_FORMAT = 4002;
    public static final int MAX_DIGITS = 10;
    public static final int MAX_CHARACTERS = 13;
    private static final double[] EXP10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final long serialVersionUID = 3117245365189973632L;
    private static volatile Reference cacheReference = new SoftReference<Object>(null);
    private long kto;

    private Kontonummer(Number accountCode) {
        if (!Kontonummer.checkKontonummer(accountCode)) {
            throw new IllegalArgumentException(accountCode.toString());
        }
        this.kto = accountCode.longValue();
    }

    public static Kontonummer parse(String accountCode, ParsePosition pos) {
        int i;
        if (accountCode == null) {
            throw new NullPointerException("accountCode");
        }
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        Kontonummer ret = null;
        boolean sawSpace = false;
        boolean failed = false;
        ParsePosition fmtPos = new ParsePosition(0);
        int len = accountCode.length();
        int startIndex = pos.getIndex();
        int maxIndex = startIndex + 13;
        StringBuffer digits = new StringBuffer(10);
        int mode = 4001;
        int part = 0;
        int partStart = 0;
        int partEnd = 2;
        int digit = 0;
        for (i = startIndex; i < len && i < maxIndex && digits.length() < 10; ++i) {
            char c = accountCode.charAt(i);
            if (Character.isDigit(c)) {
                sawSpace = false;
                if (mode == 4002) {
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    } else {
                        digits.append(c);
                    }
                } else {
                    digits.append(c);
                }
                ++digit;
            } else if (c == ' ') {
                if (sawSpace || i == startIndex || mode == 4001 && digit != 3) {
                    failed = true;
                } else {
                    mode = 4002;
                    switch (part) {
                        case 0: {
                            partStart = 3;
                            partEnd = 5;
                            break;
                        }
                        case 1: {
                            partStart = 6;
                            partEnd = 8;
                            break;
                        }
                        case 2: {
                            partStart = 9;
                            partEnd = 9;
                            break;
                        }
                        default: {
                            failed = true;
                        }
                    }
                    ++part;
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    }
                }
                sawSpace = true;
            } else {
                failed = true;
            }
            if (!failed) continue;
            pos.setErrorIndex(i);
            break;
        }
        if (!failed) {
            Number num = new DecimalFormat("##########").parse(digits.toString(), fmtPos);
            if (num != null && fmtPos.getErrorIndex() == -1) {
                String key = num.toString();
                ret = (Kontonummer)Kontonummer.getCache().get(key);
                if (ret == null) {
                    if (!Kontonummer.checkKontonummer(num)) {
                        pos.setErrorIndex(startIndex);
                        ret = null;
                    } else {
                        pos.setIndex(i);
                        ret = new Kontonummer(num);
                        Kontonummer.getCache().put(key, ret);
                    }
                } else {
                    pos.setIndex(i);
                }
            } else {
                pos.setErrorIndex(startIndex);
            }
        }
        return ret;
    }

    public static Kontonummer parse(String accountCode) throws ParseException {
        if (accountCode == null) {
            throw new NullPointerException("accountCode");
        }
        Kontonummer kto = (Kontonummer)Kontonummer.getCache().get(accountCode);
        if (kto == null) {
            ParsePosition pos = new ParsePosition(0);
            kto = Kontonummer.parse(accountCode, pos);
            if (kto == null || pos.getErrorIndex() != -1 || pos.getIndex() < accountCode.length()) {
                throw new ParseException(accountCode, pos.getErrorIndex() != -1 ? pos.getErrorIndex() : pos.getIndex());
            }
            Kontonummer.getCache().put(accountCode, kto);
        }
        return kto;
    }

    public static Kontonummer valueOf(Number accountCode) {
        if (accountCode == null) {
            throw new NullPointerException("accountCode");
        }
        String key = accountCode.toString();
        Kontonummer ret = (Kontonummer)Kontonummer.getCache().get(key);
        if (ret == null) {
            ret = new Kontonummer(accountCode);
            Kontonummer.getCache().put(key, ret);
        }
        return ret;
    }

    public static Kontonummer valueOf(String accountCode) {
        try {
            return Kontonummer.parse(accountCode);
        }
        catch (ParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(accountCode).initCause(e);
        }
    }

    public static boolean checkKontonummer(Number accountCode) {
        boolean valid;
        boolean bl = valid = accountCode != null;
        if (valid) {
            long num = accountCode.longValue();
            valid = num > 0L && num < 10000000000L;
        }
        return valid;
    }

    public int intValue() {
        return (int)this.kto;
    }

    public long longValue() {
        return this.kto;
    }

    public float floatValue() {
        return this.kto;
    }

    public double doubleValue() {
        return this.kto;
    }

    public StringBuffer format(int style, StringBuffer toAppendTo) {
        if (toAppendTo == null) {
            throw new NullPointerException("toAppendTo");
        }
        if (style != 4001 && style != 4002) {
            throw new IllegalArgumentException(Integer.toString(style));
        }
        int[] digits = Kontonummer.toDigits(this.kto);
        int lastDigit = 0;
        for (int i = digits.length - 1; i >= 0; --i) {
            if (digits[i] != 0 || lastDigit > 0) {
                toAppendTo.append(digits[i]);
                ++lastDigit;
            }
            if (style != 4002 || lastDigit != 3 && lastDigit != 6 && lastDigit != 9) continue;
            toAppendTo.append(' ');
        }
        return toAppendTo;
    }

    public String format(int style) {
        return this.format(style, new StringBuffer()).toString();
    }

    public static String toString(Kontonummer kontonummer) {
        if (kontonummer == null) {
            throw new NullPointerException("kontonummer");
        }
        return kontonummer.format(4001);
    }

    private static int[] toDigits(long number) {
        int[] ret = new int[10];
        for (int i = 9; i >= 0; --i) {
            long subst = 0L;
            for (int j = i + 1; j < 10; ++j) {
                subst = (long)((double)subst + (double)ret[j] * EXP10[j]);
            }
            ret[i] = (int)Math.floor((double)(number - subst) / EXP10[i]);
        }
        return ret;
    }

    private String internalString() {
        return new StringBuffer(500).append("{accountCode=").append(this.kto).append('}').toString();
    }

    private static Map getCache() {
        Map cache = (Map)cacheReference.get();
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap(1024));
            cacheReference = new SoftReference(cache);
        }
        return cache;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (!(o instanceof Kontonummer)) {
            throw new ClassCastException(o.getClass().getName());
        }
        int result = 0;
        Kontonummer that = (Kontonummer)o;
        if (!this.equals(that)) {
            result = this.kto > that.kto ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean equal;
        boolean bl = equal = o == this;
        if (!equal && o instanceof Kontonummer) {
            equal = this.kto == ((Kontonummer)o).kto;
        }
        return equal;
    }

    public int hashCode() {
        return (int)(this.kto ^ this.kto >>> 32);
    }

    public String toString() {
        return super.toString() + this.internalString();
    }
}

