/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jdtaus.core.container.ContainerFactory;
import org.jdtaus.core.container.PropertyException;

public class Textschluessel
implements Cloneable,
Comparable,
Serializable {
    public static final String PROP_KEY = "org.jdtaus.banking.Textschluessel.PROP_KEY";
    public static final String PROP_EXTENSION = "org.jdtaus.banking.Textschluessel.PROP_EXTENSION";
    public static final String PROP_VALID_TO = "org.jdtaus.banking.Textschluessel.PROP_VALID_TO";
    public static final String PROP_VALID_FROM = "org.jdtaus.banking.Textschluessel.PROP_VALID_FROM";
    public static final String PROP_DEBIT = "org.jdtaus.banking.Textschluessel.PROP_DEBIT";
    public static final String PROP_REMITTANCE = "org.jdtaus.banking.Textschluessel.PROP_REMITTANCE";
    public static final String PROP_VARIABLE = "org.jdtaus.banking.Textschluessel.PROP_VARIABLE";
    public static final String PROP_SHORTDESCRIPTION = "org.jdtaus.banking.Textschluessel.PROP_SHORTDESCRIPTION";
    private static final long serialVersionUID = -8556424800883022756L;
    private int key;
    private int extension;
    private Date validFrom;
    private transient long validFromMillis;
    private Date validTo;
    private transient long validToMillis;
    private boolean debit;
    private boolean remittance;
    private boolean variable;
    private Map shortDescriptions = new HashMap(10);
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;

    public Textschluessel() {
        this.assertValidProperties();
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int value) {
        this.key = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public int getExtension() {
        return this.extension;
    }

    public void setExtension(int value) {
        this.extension = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public Date getValidFrom() {
        return this.validFrom != null ? (Date)this.validFrom.clone() : null;
    }

    public void setValidFrom(Date value) {
        if (value == null) {
            this.validFrom = null;
            this.validFromMillis = 0L;
        } else {
            this.validFrom = (Date)value.clone();
            this.validFromMillis = value.getTime();
        }
    }

    public Date getValidTo() {
        return this.validTo != null ? (Date)this.validTo.clone() : null;
    }

    public void setValidTo(Date value) {
        if (value == null) {
            this.validTo = null;
            this.validToMillis = 0L;
        } else {
            this.validTo = (Date)value.clone();
            this.validToMillis = 0L;
        }
    }

    public boolean isValidAt(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        return !(this.validFrom != null && this.validFromMillis > date.getTime() || this.validTo != null && this.validToMillis < date.getTime());
    }

    public boolean isDebit() {
        return this.debit;
    }

    public void setDebit(boolean value) {
        this.debit = value;
    }

    public boolean isRemittance() {
        return this.remittance;
    }

    public void setRemittance(boolean value) {
        this.remittance = value;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public void setVariable(boolean value) {
        this.variable = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public String getShortDescription(Locale locale) {
        Locale l = locale == null ? Locale.getDefault() : locale;
        this.assertValidProperties();
        String description = (String)this.shortDescriptions.get(l.getLanguage().toLowerCase());
        if (description == null) {
            description = (String)this.shortDescriptions.get(this.getDefaultLanguage().toLowerCase());
        }
        if (description == null) {
            description = (String)this.shortDescriptions.get(Locale.getDefault().getLanguage().toLowerCase());
        }
        if (description == null) {
            description = this.getTextschluesselDescriptionMessage(this.getLocale(), new Integer(this.getKey()), new Integer(this.getExtension()));
        }
        return new MessageFormat(description, l).format(new Object[]{new Integer(this.getKey()), new Integer(this.getExtension())});
    }

    public String setShortDescription(Locale locale, String shortDescription) {
        if (shortDescription == null) {
            throw new NullPointerException("shortDescription");
        }
        Locale l = locale == null ? Locale.getDefault() : locale;
        return this.shortDescriptions.put(l.getLanguage().toLowerCase(), shortDescription);
    }

    public Locale[] getLocales() {
        HashSet<Locale> locales = new HashSet<Locale>(this.shortDescriptions.size());
        Iterator it = this.shortDescriptions.keySet().iterator();
        while (it.hasNext()) {
            locales.add(new Locale((String)it.next()));
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    protected void assertValidProperties() {
        if (this.getDefaultLanguage() == null || this.getDefaultLanguage().length() <= 0) {
            throw new PropertyException("defaultLanguage", (Object)this.getDefaultLanguage());
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (!(o instanceof Textschluessel)) {
            throw new ClassCastException(o.getClass().getName());
        }
        int result = 0;
        Textschluessel that = (Textschluessel)o;
        if (!this.equals(that)) {
            int n = this.key == that.key ? 0 : (result = this.key > that.key ? 1 : -1);
            if (result == 0 && this.extension != that.extension) {
                result = this.extension > that.extension ? 1 : -1;
            }
        }
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.validFrom != null) {
            this.validFromMillis = this.validFrom.getTime();
        }
        if (this.validTo != null) {
            this.validToMillis = this.validTo.getTime();
        }
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = o == this;
        if (!ret && o instanceof Textschluessel) {
            Textschluessel that = (Textschluessel)o;
            ret = this.isVariable() ? that.isVariable() && this.key == that.getKey() : !that.isVariable() && this.key == that.getKey() && this.extension == that.getExtension();
        }
        return ret;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            int hc = 23;
            hc = 37 * hc + (this.variable ? 0 : 1);
            hc = 37 * hc + this.key;
            this.hashCode = hc = 37 * hc + this.extension;
        }
        return this.hashCode;
    }

    public String toString() {
        return super.toString() + this.internalString();
    }

    private String internalString() {
        return new StringBuffer(200).append('{').append("key=").append(this.key).append(", extension=").append(this.extension).append(", validFrom=").append(this.validFrom).append(", validTo=").append(this.validTo).append(", debit=").append(this.debit).append(", remittance=").append(this.remittance).append(", variable=").append(this.variable).append(", shortDescription=").append(this.getShortDescription(null)).append('}').toString();
    }

    private Locale getLocale() {
        return (Locale)ContainerFactory.getContainer().getDependency((Object)this, "Locale");
    }

    private String getTextschluesselDescriptionMessage(Locale locale, Number k, Number e) {
        return ContainerFactory.getContainer().getMessage((Object)this, "textschluesselDescription", locale, (Object)new Object[]{k, e});
    }

    private String getDefaultLanguage() {
        return (String)ContainerFactory.getContainer().getProperty((Object)this, "defaultLanguage");
    }
}

