/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.dtaus;

import java.io.Serializable;
import org.jdtaus.banking.dtaus.Transaction;

public class Checksum
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7639085407620663083L;
    private int transactionCount;
    private long sumTargetAccount;
    private long sumTargetBank;
    private long sumAmount;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(int value) {
        this.transactionCount = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public long getSumTargetAccount() {
        return this.sumTargetAccount;
    }

    public void setSumTargetAccount(long value) {
        this.sumTargetAccount = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public long getSumTargetBank() {
        return this.sumTargetBank;
    }

    public void setSumTargetBank(long value) {
        this.sumTargetBank = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public long getSumAmount() {
        return this.sumAmount;
    }

    public void setSumAmount(long value) {
        this.sumAmount = value;
        this.hashCode = Integer.MIN_VALUE;
    }

    public void add(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction");
        }
        this.sumAmount += transaction.getAmount().longValue();
        this.sumTargetAccount += transaction.getTargetAccount().longValue();
        this.sumTargetBank += transaction.getTargetBank().longValue();
        this.hashCode = Integer.MIN_VALUE;
    }

    public final void substract(Transaction transaction) {
        this.subtract(transaction);
    }

    public void subtract(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction");
        }
        this.sumAmount -= transaction.getAmount().longValue();
        this.sumTargetAccount -= transaction.getTargetAccount().longValue();
        this.sumTargetBank -= transaction.getTargetBank().longValue();
        this.hashCode = Integer.MIN_VALUE;
    }

    public boolean equals(Object o) {
        boolean equal;
        boolean bl = equal = o == this;
        if (!equal && o instanceof Checksum) {
            Checksum that = (Checksum)o;
            equal = this.getSumAmount() == that.getSumAmount() && this.getSumTargetAccount() == that.getSumTargetAccount() && this.getSumTargetBank() == that.getSumTargetBank() && this.getTransactionCount() == that.getTransactionCount();
        }
        return equal;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            int hc = 23;
            hc = 37 * hc + (int)(this.sumAmount ^ this.sumAmount >>> 32);
            hc = 37 * hc + (int)(this.sumTargetAccount ^ this.sumTargetAccount >>> 32);
            hc = 37 * hc + (int)(this.sumTargetBank ^ this.sumTargetBank >>> 32);
            this.hashCode = hc = 37 * hc + this.transactionCount;
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return super.toString() + this.internalString();
    }

    private String internalString() {
        return new StringBuffer(100).append('{').append("sumAmount=").append(this.sumAmount).append(", sumTargetAccount=").append(this.sumTargetAccount).append(", sumTargetBank=").append(this.sumTargetBank).append(", transactionCount=").append(this.transactionCount).append('}').toString();
    }
}

