package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class ContainerErrorBundle{ 

/** <pre> Container error: {0}</pre>. */
public static String getContainerErrorText(final Locale locale) {
    return getMessage("containerError", locale);
}

/** <pre> Container error: {0}</pre>. */
public static MessageFormat getContainerErrorMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("containerError", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.ContainerError", locale).getString(key);
}

}
