/*
 *  jDTAUS - DTAUS fileformat.
 *  Copyright (c) 2005 Christian Schulte <cs@schulte.it>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
package org.jdtaus.core.container;

import java.io.Serializable;

/**
 * Implementation context.
 * <p>The context stores key-value pairs bound to a client. For every method
 * invocation identical clients get identical contexts.</p>
 *
 * @author <a href="mailto:cs@schulte.it">Christian Schulte</a>
 * @version $Id: Context.java 1914 2007-03-01 02:20:44Z schulte2005 $
 *
 * @see ContextFactory
 */
public interface Context
{

    /**
     * Gets an attribute from the context.
     *
     * @param key Key of the attribute to return.
     *
     * @return The attribute with key {@code key} or {@code null} if no
     * such attribute is held by the context.
     *
     * @throws NullPointerException if {@code key} is {@code null}.
     */
    Object getAttribute(String key);

    /**
     * Sets an attribute in the context.
     *
     * @param key Key of the attribute to store {@code o} with.
     * @param o Object to store with key {@code key}.
     *
     * @return previous value associated with {@code key}, or {@code null}
     * if there was no attribute for {@code key}. Returning {@code null} may
     * also indicate that the context previously associated {@code null} with
     * the specified key, if the implementation supports {@code null} values.
     *
     * @throws NullPointerException if {@code key} is {@code null}.
     */
    Object setAttribute(String key, Serializable o);

    /**
     * Removes an attribute from the context.
     *
     * @param key Key of the attribute to remove.
     *
     * @return previous value associated with {@code key}, or {@code null}
     * if there was no attribute for {@code key}. Returning {@code null} may
     * also indicate that the context previously associated {@code null} with
     * the specified key, if the implementation supports {@code null} values.
     *
     * @throws NullPointerException if {@code key} is {@code null}.
     */
    Object removeAttribute(String key);

}
