package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class ContextErrorBundle{ 

/** <pre> Context error: {0}</pre>. */
public static String getContextErrorText(final Locale locale) {
    return getMessage("contextError", locale);
}

/** <pre> Context error: {0}</pre>. */
public static MessageFormat getContextErrorMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("contextError", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.ContextError", locale).getString(key);
}

}
