package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class DuplicateDependencyExceptionBundle{ 

/** <pre> Multiple dependencies with name "{0}".</pre>. */
public static String getDuplicateDependencyText(final Locale locale) {
    return getMessage("duplicateDependency", locale);
}

/** <pre> Multiple dependencies with name "{0}".</pre>. */
public static MessageFormat getDuplicateDependencyMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("duplicateDependency", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.DuplicateDependencyException", locale).getString(key);
}

}
