package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class DuplicateImplementationExceptionBundle{ 

/** <pre> Multiple implementations with identifier "{0}".</pre>. */
public static String getDuplicateImplementationText(final Locale locale) {
    return getMessage("duplicateImplementation", locale);
}

/** <pre> Multiple implementations with identifier "{0}".</pre>. */
public static MessageFormat getDuplicateImplementationMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("duplicateImplementation", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.DuplicateImplementationException", locale).getString(key);
}

}
