package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class DuplicateModuleExceptionBundle{ 

/** <pre> Multiple modules with name "{0}".</pre>. */
public static String getDuplicateModuleText(final Locale locale) {
    return getMessage("duplicateModule", locale);
}

/** <pre> Multiple modules with name "{0}".</pre>. */
public static MessageFormat getDuplicateModuleMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("duplicateModule", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.DuplicateModuleException", locale).getString(key);
}

}
