package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class DuplicatePropertyExceptionBundle{ 

/** <pre> Multiple properties with name "{0}".</pre>. */
public static String getDuplicatePropertyText(final Locale locale) {
    return getMessage("duplicateProperty", locale);
}

/** <pre> Multiple properties with name "{0}".</pre>. */
public static MessageFormat getDuplicatePropertyMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("duplicateProperty", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.DuplicatePropertyException", locale).getString(key);
}

}
