package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class DuplicateSpecificationExceptionBundle{ 

/** <pre> Multiple specifications identified by "{0}".</pre>. */
public static String getDuplicateSpecificationText(final Locale locale) {
    return getMessage("duplicateSpecification", locale);
}

/** <pre> Multiple specifications identified by "{0}".</pre>. */
public static MessageFormat getDuplicateSpecificationMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("duplicateSpecification", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.DuplicateSpecificationException", locale).getString(key);
}

}
