/*
 *  jDTAUS - DTAUS fileformat.
 *  Copyright (c) 2005 Christian Schulte <cs@schulte.it>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
package org.jdtaus.core.container;

import java.util.Locale;

/**
 * Gets thrown when an implementation fails to operate.
 *
 * @author <a href="mailto:cs@schulte.it">Christian Schulte</a>
 * @version $Id: ImplementationException.java 1914 2007-03-01 02:20:44Z schulte2005 $
 */
public class ImplementationException extends IllegalStateException
{

    //--Constructors------------------------------------------------------------

    /**
     * Creates a new instance of {@code ImplementationException} taking a
     * causing {@code Throwable}.
     *
     * @param implementation the failing implementation.
     * @param cause the causing throwable.
     */
    public ImplementationException(final Implementation implementation,
        final Throwable cause)
    {

        super(ImplementationExceptionBundle.getImplementationExceptionMessage(
            Locale.getDefault()).format(new Object[] {
            cause != null ? cause.getMessage() : null }));

        this.initCause(cause);
        this.implementation = implementation;
    }

    /**
     * Creates a new instance of {@code ImplementationException} taking a
     * message.
     *
     * @param implementation the failing implementation.
     * @param msg the message describing the error.
     */
    public ImplementationException(final Implementation implementation,
        final String msg)
    {

        super(ImplementationExceptionBundle.getImplementationExceptionMessage(
            Locale.getDefault()).format(new Object[] { msg }));

        this.implementation = implementation;
    }

    //------------------------------------------------------------Constructors--
    //--ImplementationException-------------------------------------------------

    /**
     * The failing implementation.
     * @serial
     */
    private Implementation implementation;

    /**
     * Gets the failing implementation.
     *
     * @return the failing implementation or {@code null}.
     */
    public Implementation getImplementation()
    {
        return this.implementation;
    }

    //-------------------------------------------------ImplementationException--

}
