package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class ImplementationExceptionBundle{ 

/** <pre> Bug: {0}.</pre>. */
public static String getImplementationExceptionText(final Locale locale) {
    return getMessage("implementationException", locale);
}

/** <pre> Bug: {0}.</pre>. */
public static MessageFormat getImplementationExceptionMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("implementationException", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.ImplementationException", locale).getString(key);
}

}
