package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class InstantiationExceptionBundle{ 

/** <pre> Error during instantiation: {0}</pre>. */
public static String getInstantiationText(final Locale locale) {
    return getMessage("instantiation", locale);
}

/** <pre> Error during instantiation: {0}</pre>. */
public static MessageFormat getInstantiationMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("instantiation", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.InstantiationException", locale).getString(key);
}

}
