package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class MissingImplementationExceptionBundle{ 

/** <pre> Implementation "{0}" is missing.</pre>. */
public static String getMissingImplementationText(final Locale locale) {
    return getMessage("missingImplementation", locale);
}

/** <pre> Implementation "{0}" is missing.</pre>. */
public static MessageFormat getMissingImplementationMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("missingImplementation", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.MissingImplementationException", locale).getString(key);
}

}
