package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class MissingModuleExceptionBundle{ 

/** <pre> Module "{0}" is missing.</pre>. */
public static String getMissingModuleText(final Locale locale) {
    return getMessage("missingModule", locale);
}

/** <pre> Module "{0}" is missing.</pre>. */
public static MessageFormat getMissingModuleMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("missingModule", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.MissingModuleException", locale).getString(key);
}

}
