package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class MissingPropertyExceptionBundle{ 

/** <pre> Property "{0}" is missing.</pre>. */
public static String getMissingPropertyText(final Locale locale) {
    return getMessage("missingProperty", locale);
}

/** <pre> Property "{0}" is missing.</pre>. */
public static MessageFormat getMissingPropertyMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("missingProperty", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.MissingPropertyException", locale).getString(key);
}

}
