package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class MissingSpecificationExceptionBundle{ 

/** <pre> Specification "{0}" is missing.</pre>. */
public static String getMissingSpecificationText(final Locale locale) {
    return getMessage("missingSpecification", locale);
}

/** <pre> Specification "{0}" is missing.</pre>. */
public static MessageFormat getMissingSpecificationMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("missingSpecification", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.MissingSpecificationException", locale).getString(key);
}

}
