package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class ModelErrorBundle{ 

/** <pre> Model error: {0}</pre>. */
public static String getModelErrorText(final Locale locale) {
    return getMessage("modelError", locale);
}

/** <pre> Model error: {0}</pre>. */
public static MessageFormat getModelErrorMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("modelError", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.ModelError", locale).getString(key);
}

}
