package org.jdtaus.core.container;

import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;

abstract class PropertyExceptionBundle{ 

/** <pre> Invalid value "{1}" for property "{0}".</pre>. */
public static String getPropertyExceptionText(final Locale locale) {
    return getMessage("propertyException", locale);
}

/** <pre> Invalid value "{1}" for property "{0}".</pre>. */
public static MessageFormat getPropertyExceptionMessage(Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
return new MessageFormat(getMessage("propertyException", locale), locale);
}

private static String getMessage(final String key, Locale locale) {
    if(locale == null) { locale = Locale.getDefault(); }
    return ResourceBundle.getBundle(
        "org.jdtaus.core.container.PropertyException", locale).getString(key);
}

}
