/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.validator.RecordValidator;

public class BeanValidationRecordValidator<P>
implements RecordValidator<P> {
    private Validator validator;

    public BeanValidationRecordValidator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    public Record<P> processRecord(Record<P> record) throws Exception {
        Set constraintViolationSet = this.validator.validate(record.getPayload(), new Class[0]);
        if (!constraintViolationSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolationSet) {
                stringBuilder.append("Invalid value '").append(constraintViolation.getInvalidValue()).append("' ").append("for property '").append(constraintViolation.getPropertyPath()).append("' : ").append(constraintViolation.getMessage()).append(Utils.LINE_SEPARATOR);
            }
            throw new Exception(stringBuilder.toString());
        }
        return record;
    }
}

