// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.delete
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.CollectionCreationResult

public class CollectionApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Adds items to a collection.
	 *
	 * @param collectionId The collection id.
	 * @param ids Item ids, comma delimited.
	 */
	public suspend fun addToCollection(collectionId: UUID, ids: Collection<UUID> = emptyList()):
			Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("collectionId", collectionId)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("ids", ids)
		}
		val data = null
		val response = api.post<Unit>("/Collections/{collectionId}/Items", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Creates a new collection.
	 *
	 * @param name The name of the collection.
	 * @param ids Item Ids to add to the collection.
	 * @param parentId Optional. Create the collection within a specific folder.
	 * @param isLocked Whether or not to lock the new collection.
	 */
	public suspend fun createCollection(
		name: String? = null,
		ids: Collection<String>? = emptyList(),
		parentId: UUID? = null,
		isLocked: Boolean? = false,
	): Response<CollectionCreationResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(4) {
			put("name", name)
			put("ids", ids)
			put("parentId", parentId)
			put("isLocked", isLocked)
		}
		val data = null
		val response = api.post<CollectionCreationResult>("/Collections", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Removes items from a collection.
	 *
	 * @param collectionId The collection id.
	 * @param ids Item ids, comma delimited.
	 */
	public suspend fun removeFromCollection(collectionId: UUID, ids: Collection<UUID> = emptyList()):
			Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("collectionId", collectionId)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("ids", ids)
		}
		val data = null
		val response = api.delete<Unit>("/Collections/{collectionId}/Items", pathParameters,
				queryParameters, data)
		return response
	}
}
