// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.String
import kotlin.Unit
import kotlin.collections.buildMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.DisplayPreferencesDto

public class DisplayPreferencesApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Get Display Preferences.
	 *
	 * @param displayPreferencesId Display preferences id.
	 * @param userId User id.
	 * @param client Client.
	 */
	public suspend fun getDisplayPreferences(
		displayPreferencesId: String,
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		client: String,
	): Response<DisplayPreferencesDto> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("displayPreferencesId", displayPreferencesId)
		}
		val queryParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("client", client)
		}
		val data = null
		val response = api.`get`<DisplayPreferencesDto>("/DisplayPreferences/{displayPreferencesId}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Update Display Preferences.
	 *
	 * @param displayPreferencesId Display preferences id.
	 * @param userId User Id.
	 * @param client Client.
	 */
	public suspend fun updateDisplayPreferences(
		displayPreferencesId: String,
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		client: String,
		`data`: DisplayPreferencesDto,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("displayPreferencesId", displayPreferencesId)
		}
		val queryParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("client", client)
		}
		val response = api.post<Unit>("/DisplayPreferences/{displayPreferencesId}", pathParameters,
				queryParameters, data)
		return response
	}
}
