// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDto
import org.jellyfin.sdk.model.api.BaseItemDtoQueryResult
import org.jellyfin.sdk.model.api.BaseItemKind
import org.jellyfin.sdk.model.api.ImageType
import org.jellyfin.sdk.model.api.ItemFields
import org.jellyfin.sdk.model.api.SortOrder
import org.jellyfin.sdk.model.api.request.GetGenresRequest

public class GenresApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets a genre, by name.
	 *
	 * @param genreName The genre name.
	 * @param userId The user id.
	 */
	public suspend fun getGenre(genreName: String, userId: UUID? = null): Response<BaseItemDto> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("genreName", genreName)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val data = null
		val response = api.`get`<BaseItemDto>("/Genres/{genreName}", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Gets all genres from a given item, folder, or the entire library.
	 *
	 * @param startIndex Optional. The record index to start at. All items with a lower index will be
	 * dropped from the results.
	 * @param limit Optional. The maximum number of records to return.
	 * @param searchTerm The search term.
	 * @param parentId Specify this to localize the search to a specific item or folder. Omit to use
	 * the root.
	 * @param fields Optional. Specify additional fields of information to return in the output.
	 * @param excludeItemTypes Optional. If specified, results will be filtered out based on item type.
	 * This allows multiple, comma delimited.
	 * @param includeItemTypes Optional. If specified, results will be filtered in based on item type.
	 * This allows multiple, comma delimited.
	 * @param isFavorite Optional filter by items that are marked as favorite, or not.
	 * @param imageTypeLimit Optional, the max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param userId User id.
	 * @param nameStartsWithOrGreater Optional filter by items whose name is sorted equally or greater
	 * than a given input string.
	 * @param nameStartsWith Optional filter by items whose name is sorted equally than a given input
	 * string.
	 * @param nameLessThan Optional filter by items whose name is equally or lesser than a given input
	 * string.
	 * @param sortBy Optional. Specify one or more sort orders, comma delimited.
	 * @param sortOrder Sort Order - Ascending,Descending.
	 * @param enableImages Optional, include image information in output.
	 * @param enableTotalRecordCount Optional. Include total record count.
	 */
	public suspend fun getGenres(
		startIndex: Int? = null,
		limit: Int? = null,
		searchTerm: String? = null,
		parentId: UUID? = null,
		fields: Collection<ItemFields>? = emptyList(),
		excludeItemTypes: Collection<BaseItemKind>? = emptyList(),
		includeItemTypes: Collection<BaseItemKind>? = emptyList(),
		isFavorite: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		userId: UUID? = null,
		nameStartsWithOrGreater: String? = null,
		nameStartsWith: String? = null,
		nameLessThan: String? = null,
		sortBy: Collection<String>? = emptyList(),
		sortOrder: Collection<SortOrder>? = emptyList(),
		enableImages: Boolean? = true,
		enableTotalRecordCount: Boolean? = true,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(18) {
			put("startIndex", startIndex)
			put("limit", limit)
			put("searchTerm", searchTerm)
			put("parentId", parentId)
			put("fields", fields)
			put("excludeItemTypes", excludeItemTypes)
			put("includeItemTypes", includeItemTypes)
			put("isFavorite", isFavorite)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("userId", userId)
			put("nameStartsWithOrGreater", nameStartsWithOrGreater)
			put("nameStartsWith", nameStartsWith)
			put("nameLessThan", nameLessThan)
			put("sortBy", sortBy)
			put("sortOrder", sortOrder)
			put("enableImages", enableImages)
			put("enableTotalRecordCount", enableTotalRecordCount)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Genres", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets all genres from a given item, folder, or the entire library.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getGenres(request: GetGenresRequest = GetGenresRequest()):
			Response<BaseItemDtoQueryResult> = getGenres(
		startIndex = request.startIndex,
		limit = request.limit,
		searchTerm = request.searchTerm,
		parentId = request.parentId,
		fields = request.fields,
		excludeItemTypes = request.excludeItemTypes,
		includeItemTypes = request.includeItemTypes,
		isFavorite = request.isFavorite,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		userId = request.userId,
		nameStartsWithOrGreater = request.nameStartsWithOrGreater,
		nameStartsWith = request.nameStartsWith,
		nameLessThan = request.nameLessThan,
		sortBy = request.sortBy,
		sortOrder = request.sortOrder,
		enableImages = request.enableImages,
		enableTotalRecordCount = request.enableTotalRecordCount,
	)
}
