// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import io.ktor.utils.io.ByteReadChannel
import kotlin.Any
import kotlin.Boolean
import kotlin.ByteArray
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import kotlin.require
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.delete
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.ImageFormat
import org.jellyfin.sdk.model.api.ImageInfo
import org.jellyfin.sdk.model.api.ImageType
import org.jellyfin.sdk.model.api.request.GetArtistImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetArtistImageRequest
import org.jellyfin.sdk.model.api.request.GetGenreImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetGenreImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetGenreImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetGenreImageRequest
import org.jellyfin.sdk.model.api.request.GetItemImage2DeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetItemImage2Request
import org.jellyfin.sdk.model.api.request.GetItemImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetItemImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetItemImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetItemImageRequest
import org.jellyfin.sdk.model.api.request.GetMusicGenreImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetMusicGenreImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetMusicGenreImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetMusicGenreImageRequest
import org.jellyfin.sdk.model.api.request.GetPersonImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetPersonImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetPersonImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetPersonImageRequest
import org.jellyfin.sdk.model.api.request.GetSplashscreenRequest
import org.jellyfin.sdk.model.api.request.GetStudioImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetStudioImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetStudioImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetStudioImageRequest
import org.jellyfin.sdk.model.api.request.GetUserImageByIndexDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetUserImageByIndexRequest
import org.jellyfin.sdk.model.api.request.GetUserImageDeprecatedRequest
import org.jellyfin.sdk.model.api.request.GetUserImageRequest

public class ImageApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Delete a custom splashscreen.
	 */
	public suspend fun deleteCustomSplashscreen(): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.delete<Unit>("/Branding/Splashscreen", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Delete an item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex The image index.
	 */
	public suspend fun deleteItemImage(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int? = null,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.delete<Unit>("/Items/{itemId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Delete an item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex The image index.
	 */
	public suspend fun deleteItemImageByIndex(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.delete<Unit>("/Items/{itemId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Delete the user's image.
	 *
	 * @param userId User Id.
	 * @param imageType (Unused) Image type.
	 * @param index (Unused) Image index.
	 */
	public suspend fun deleteUserImage(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		index: Int? = null,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("index", index)
		}
		val data = null
		val response = api.delete<Unit>("/Users/{userId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Delete the user's image.
	 *
	 * @param userId User Id.
	 * @param imageType (Unused) Image type.
	 * @param index (Unused) Image index.
	 */
	public suspend fun deleteUserImageByIndex(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		index: Int,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("index", index)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.delete<Unit>("/Users/{userId}/Images/{imageType}/{index}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get artist image by name.
	 *
	 * @param name Artist name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getArtistImage(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Artists/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get artist image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getArtistImage(request: GetArtistImageRequest): Response<ByteReadChannel> =
			getArtistImage(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get artist image by name.
	 *
	 * @param name Artist name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getArtistImageUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Artists/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get artist image by name.
	 *
	 * @param name Artist name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getArtistImageDeprecated(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Artists/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get artist image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getArtistImageDeprecated(request: GetArtistImageDeprecatedRequest):
			Response<ByteReadChannel> = getArtistImageDeprecated(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get artist image by name.
	 *
	 * @param name Artist name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getArtistImageDeprecatedUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Artists/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getGenreImage(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Genres/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get genre image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getGenreImage(request: GetGenreImageRequest): Response<ByteReadChannel> =
			getGenreImage(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getGenreImageUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Genres/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getGenreImageByIndex(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Genres/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get genre image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getGenreImageByIndex(request: GetGenreImageByIndexRequest):
			Response<ByteReadChannel> = getGenreImageByIndex(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getGenreImageByIndexUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Genres/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getGenreImageByIndexDeprecated(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Genres/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get genre image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getGenreImageByIndexDeprecated(request: GetGenreImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getGenreImageByIndexDeprecated(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getGenreImageByIndexDeprecatedUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Genres/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getGenreImageDeprecated(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Genres/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get genre image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getGenreImageDeprecated(request: GetGenreImageDeprecatedRequest):
			Response<ByteReadChannel> = getGenreImageDeprecated(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get genre image by name.
	 *
	 * @param name Genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getGenreImageDeprecatedUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Genres/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getItemImage(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getItemImage(request: GetItemImageRequest): Response<ByteReadChannel> =
			getItemImage(
		itemId = request.itemId,
		imageType = request.imageType,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		tag = request.tag,
		format = request.format,
		addPlayedIndicator = request.addPlayedIndicator,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getItemImageUrl(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param imageIndex Image index.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getItemImage2(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int,
		maxHeight: Int,
		tag: String,
		format: ImageFormat,
		percentPlayed: Double,
		unplayedCount: Int,
		imageIndex: Int,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(9) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("tag", tag)
			put("format", format)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(9) {
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response =
				api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getItemImage2(request: GetItemImage2Request): Response<ByteReadChannel> =
			getItemImage2(
		itemId = request.itemId,
		imageType = request.imageType,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		tag = request.tag,
		format = request.format,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		imageIndex = request.imageIndex,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param imageIndex Image index.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getItemImage2Url(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int,
		maxHeight: Int,
		tag: String,
		format: ImageFormat,
		percentPlayed: Double,
		unplayedCount: Int,
		imageIndex: Int,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(9) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("tag", tag)
			put("format", format)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(9) {
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}",
				pathParameters, queryParameters, includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param imageIndex Image index.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImage2Deprecated(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int,
		maxHeight: Int,
		tag: String,
		format: ImageFormat,
		percentPlayed: Double,
		unplayedCount: Int,
		imageIndex: Int,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(9) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("tag", tag)
			put("format", format)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(10) {
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response =
				api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImage2Deprecated(request: GetItemImage2DeprecatedRequest):
			Response<ByteReadChannel> = getItemImage2Deprecated(
		itemId = request.itemId,
		imageType = request.imageType,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		tag = request.tag,
		format = request.format,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		imageIndex = request.imageIndex,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param imageIndex Image index.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getItemImage2DeprecatedUrl(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int,
		maxHeight: Int,
		tag: String,
		format: ImageFormat,
		percentPlayed: Double,
		unplayedCount: Int,
		imageIndex: Int,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(9) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("tag", tag)
			put("format", format)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(10) {
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}",
				pathParameters, queryParameters, includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getItemImageByIndex(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getItemImageByIndex(request: GetItemImageByIndexRequest):
			Response<ByteReadChannel> = getItemImageByIndex(
		itemId = request.itemId,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		tag = request.tag,
		format = request.format,
		addPlayedIndicator = request.addPlayedIndicator,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getItemImageByIndexUrl(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImageByIndexDeprecated(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		cropWhitespace: Boolean? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("cropWhitespace", cropWhitespace)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImageByIndexDeprecated(request: GetItemImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getItemImageByIndexDeprecated(
		itemId = request.itemId,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		tag = request.tag,
		cropWhitespace = request.cropWhitespace,
		format = request.format,
		addPlayedIndicator = request.addPlayedIndicator,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getItemImageByIndexDeprecatedUrl(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		cropWhitespace: Boolean? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("cropWhitespace", cropWhitespace)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImageDeprecated(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		cropWhitespace: Boolean? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("cropWhitespace", cropWhitespace)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Items/{itemId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets the item's image.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getItemImageDeprecated(request: GetItemImageDeprecatedRequest):
			Response<ByteReadChannel> = getItemImageDeprecated(
		itemId = request.itemId,
		imageType = request.imageType,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		tag = request.tag,
		cropWhitespace = request.cropWhitespace,
		format = request.format,
		addPlayedIndicator = request.addPlayedIndicator,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Gets the item's image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param format Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getItemImageDeprecatedUrl(
		itemId: UUID,
		imageType: ImageType,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		tag: String? = null,
		cropWhitespace: Boolean? = null,
		format: ImageFormat? = null,
		addPlayedIndicator: Boolean? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("tag", tag)
			put("cropWhitespace", cropWhitespace)
			put("format", format)
			put("addPlayedIndicator", addPlayedIndicator)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Items/{itemId}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get item image infos.
	 *
	 * @param itemId Item id.
	 */
	public suspend fun getItemImageInfos(itemId: UUID): Response<List<ImageInfo>> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<ImageInfo>>("/Items/{itemId}/Images", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getMusicGenreImage(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/MusicGenres/{name}/Images/{imageType}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getMusicGenreImage(request: GetMusicGenreImageRequest):
			Response<ByteReadChannel> = getMusicGenreImage(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getMusicGenreImageUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/MusicGenres/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getMusicGenreImageByIndex(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/MusicGenres/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getMusicGenreImageByIndex(request: GetMusicGenreImageByIndexRequest):
			Response<ByteReadChannel> = getMusicGenreImageByIndex(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getMusicGenreImageByIndexUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/MusicGenres/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getMusicGenreImageByIndexDeprecated(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/MusicGenres/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend
			fun getMusicGenreImageByIndexDeprecated(request: GetMusicGenreImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getMusicGenreImageByIndexDeprecated(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getMusicGenreImageByIndexDeprecatedUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/MusicGenres/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getMusicGenreImageDeprecated(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/MusicGenres/{name}/Images/{imageType}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music genre image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getMusicGenreImageDeprecated(request: GetMusicGenreImageDeprecatedRequest):
			Response<ByteReadChannel> = getMusicGenreImageDeprecated(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get music genre image by name.
	 *
	 * @param name Music genre name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getMusicGenreImageDeprecatedUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/MusicGenres/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getPersonImage(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Persons/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get person image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getPersonImage(request: GetPersonImageRequest): Response<ByteReadChannel> =
			getPersonImage(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getPersonImageUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Persons/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getPersonImageByIndex(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Persons/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get person image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getPersonImageByIndex(request: GetPersonImageByIndexRequest):
			Response<ByteReadChannel> = getPersonImageByIndex(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getPersonImageByIndexUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Persons/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getPersonImageByIndexDeprecated(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Persons/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get person image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend
			fun getPersonImageByIndexDeprecated(request: GetPersonImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getPersonImageByIndexDeprecated(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getPersonImageByIndexDeprecatedUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Persons/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getPersonImageDeprecated(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Persons/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get person image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getPersonImageDeprecated(request: GetPersonImageDeprecatedRequest):
			Response<ByteReadChannel> = getPersonImageDeprecated(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get person image by name.
	 *
	 * @param name Person name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getPersonImageDeprecatedUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Persons/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Generates or gets the splashscreen.
	 *
	 * @param tag Supply the cache tag from the item object to receive strong caching headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param blur Blur image.
	 * @param backgroundColor Apply a background color for transparent images.
	 * @param foregroundLayer Apply a foreground layer on top of the image.
	 * @param quality Quality setting, from 0-100.
	 */
	public suspend fun getSplashscreen(
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		quality: Int? = 90,
	): Response<ByteReadChannel> {
		val pathParameters = emptyMap<String, Any?>()
		require(quality in 0..100) { "Parameter \"quality\" must be in range 0..100 (inclusive)." }
		val queryParameters = buildMap<String, Any?>(12) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("quality", quality)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Branding/Splashscreen", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Generates or gets the splashscreen.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getSplashscreen(request: GetSplashscreenRequest = GetSplashscreenRequest()):
			Response<ByteReadChannel> = getSplashscreen(
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		width = request.width,
		height = request.height,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		quality = request.quality,
	)

	/**
	 * Generates or gets the splashscreen.
	 *
	 * @param tag Supply the cache tag from the item object to receive strong caching headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param blur Blur image.
	 * @param backgroundColor Apply a background color for transparent images.
	 * @param foregroundLayer Apply a foreground layer on top of the image.
	 * @param quality Quality setting, from 0-100.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getSplashscreenUrl(
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		width: Int? = null,
		height: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		quality: Int? = 90,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = emptyMap<String, Any?>()
		require(quality in 0..100) { "Parameter \"quality\" must be in range 0..100 (inclusive)." }
		val queryParameters = buildMap<String, Any?>(12) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("width", width)
			put("height", height)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("quality", quality)
		}
		return api.createUrl("/Branding/Splashscreen", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getStudioImage(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Studios/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get studio image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getStudioImage(request: GetStudioImageRequest): Response<ByteReadChannel> =
			getStudioImage(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getStudioImageUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Studios/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getStudioImageByIndex(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Studios/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get studio image by name.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getStudioImageByIndex(request: GetStudioImageByIndexRequest):
			Response<ByteReadChannel> = getStudioImageByIndex(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getStudioImageByIndexUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Studios/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getStudioImageByIndexDeprecated(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Studios/{name}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get studio image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend
			fun getStudioImageByIndexDeprecated(request: GetStudioImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getStudioImageByIndexDeprecated(
		name = request.name,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getStudioImageByIndexDeprecatedUrl(
		name: String,
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Studios/{name}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getStudioImageDeprecated(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Studios/{name}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get studio image by name.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getStudioImageDeprecated(request: GetStudioImageDeprecatedRequest):
			Response<ByteReadChannel> = getStudioImageDeprecated(
		name = request.name,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get studio image by name.
	 *
	 * @param name Studio name.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getStudioImageDeprecatedUrl(
		name: String,
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Studios/{name}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	public suspend fun getUserImage(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Users/{userId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get user profile image.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getUserImage(request: GetUserImageRequest): Response<ByteReadChannel> =
			getUserImage(
		userId = request.userId,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getUserImageUrl(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Users/{userId}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	public suspend fun getUserImageByIndex(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Users/{userId}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get user profile image.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getUserImageByIndex(request: GetUserImageByIndexRequest):
			Response<ByteReadChannel> = getUserImageByIndex(
		userId = request.userId,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getUserImageByIndexUrl(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(15) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Users/{userId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getUserImageByIndexDeprecated(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Users/{userId}/Images/{imageType}/{imageIndex}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get user profile image.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getUserImageByIndexDeprecated(request: GetUserImageByIndexDeprecatedRequest):
			Response<ByteReadChannel> = getUserImageByIndexDeprecated(
		userId = request.userId,
		imageType = request.imageType,
		imageIndex = request.imageIndex,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
	)

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param imageIndex Image index.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getUserImageByIndexDeprecatedUrl(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		imageIndex: Int,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(16) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
		}
		return api.createUrl("/Users/{userId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, includeCredentials)
	}

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getUserImageDeprecated(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		val data = null
		val response = api.`get`<ByteReadChannel>("/Users/{userId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get user profile image.
	 *
	 * @param request The request paramaters
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public suspend fun getUserImageDeprecated(request: GetUserImageDeprecatedRequest):
			Response<ByteReadChannel> = getUserImageDeprecated(
		userId = request.userId,
		imageType = request.imageType,
		tag = request.tag,
		format = request.format,
		maxWidth = request.maxWidth,
		maxHeight = request.maxHeight,
		percentPlayed = request.percentPlayed,
		unplayedCount = request.unplayedCount,
		width = request.width,
		height = request.height,
		quality = request.quality,
		fillWidth = request.fillWidth,
		fillHeight = request.fillHeight,
		cropWhitespace = request.cropWhitespace,
		addPlayedIndicator = request.addPlayedIndicator,
		blur = request.blur,
		backgroundColor = request.backgroundColor,
		foregroundLayer = request.foregroundLayer,
		imageIndex = request.imageIndex,
	)

	/**
	 * Get user profile image.
	 *
	 * @param userId User id.
	 * @param imageType Image type.
	 * @param tag Optional. Supply the cache tag from the item object to receive strong caching
	 * headers.
	 * @param format Determines the output format of the image - original,gif,jpg,png.
	 * @param maxWidth The maximum image width to return.
	 * @param maxHeight The maximum image height to return.
	 * @param percentPlayed Optional. Percent to render for the percent played overlay.
	 * @param unplayedCount Optional. Unplayed count overlay to render.
	 * @param width The fixed image width to return.
	 * @param height The fixed image height to return.
	 * @param quality Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most
	 * cases.
	 * @param fillWidth Width of box to fill.
	 * @param fillHeight Height of box to fill.
	 * @param cropWhitespace Optional. Specify if whitespace should be cropped out of the image.
	 * True/False. If unspecified, whitespace will be cropped from logos and clear art.
	 * @param addPlayedIndicator Optional. Add a played indicator.
	 * @param blur Optional. Blur image.
	 * @param backgroundColor Optional. Apply a background color for transparent images.
	 * @param foregroundLayer Optional. Apply a foreground layer on top of the image.
	 * @param imageIndex Image index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	@Deprecated("This member is deprecated and may be removed in the future")
	public fun getUserImageDeprecatedUrl(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		tag: String? = null,
		format: ImageFormat? = null,
		maxWidth: Int? = null,
		maxHeight: Int? = null,
		percentPlayed: Double? = null,
		unplayedCount: Int? = null,
		width: Int? = null,
		height: Int? = null,
		quality: Int? = null,
		fillWidth: Int? = null,
		fillHeight: Int? = null,
		cropWhitespace: Boolean? = null,
		addPlayedIndicator: Boolean? = null,
		blur: Int? = null,
		backgroundColor: String? = null,
		foregroundLayer: String? = null,
		imageIndex: Int? = null,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(17) {
			put("tag", tag)
			put("format", format)
			put("maxWidth", maxWidth)
			put("maxHeight", maxHeight)
			put("percentPlayed", percentPlayed)
			put("unplayedCount", unplayedCount)
			put("width", width)
			put("height", height)
			put("quality", quality)
			put("fillWidth", fillWidth)
			put("fillHeight", fillHeight)
			put("cropWhitespace", cropWhitespace)
			put("addPlayedIndicator", addPlayedIndicator)
			put("blur", blur)
			put("backgroundColor", backgroundColor)
			put("foregroundLayer", foregroundLayer)
			put("imageIndex", imageIndex)
		}
		return api.createUrl("/Users/{userId}/Images/{imageType}", pathParameters, queryParameters,
				includeCredentials)
	}

	/**
	 * Sets the user image.
	 *
	 * @param userId User Id.
	 * @param imageType (Unused) Image type.
	 * @param index (Unused) Image index.
	 */
	public suspend fun postUserImage(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		index: Int? = null,
		`data`: ByteArray,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("imageType", imageType)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("index", index)
		}
		val response = api.post<Unit>("/Users/{userId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Sets the user image.
	 *
	 * @param userId User Id.
	 * @param imageType (Unused) Image type.
	 * @param index (Unused) Image index.
	 */
	public suspend fun postUserImageByIndex(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		imageType: ImageType,
		index: Int,
		`data`: ByteArray,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("userId", userId)
			put("imageType", imageType)
			put("index", index)
		}
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Users/{userId}/Images/{imageType}/{index}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Set item image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 */
	public suspend fun setItemImage(
		itemId: UUID,
		imageType: ImageType,
		`data`: ByteArray,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("itemId", itemId)
			put("imageType", imageType)
		}
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Items/{itemId}/Images/{imageType}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Set item image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex (Unused) Image index.
	 */
	public suspend fun setItemImageByIndex(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		`data`: ByteArray,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Items/{itemId}/Images/{imageType}/{imageIndex}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Updates the index for an item image.
	 *
	 * @param itemId Item id.
	 * @param imageType Image type.
	 * @param imageIndex Old image index.
	 * @param newIndex New image index.
	 */
	public suspend fun updateItemImageIndex(
		itemId: UUID,
		imageType: ImageType,
		imageIndex: Int,
		newIndex: Int,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("itemId", itemId)
			put("imageType", imageType)
			put("imageIndex", imageIndex)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("newIndex", newIndex)
		}
		val data = null
		val response = api.post<Unit>("/Items/{itemId}/Images/{imageType}/{imageIndex}/Index",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Uploads a custom splashscreen.
	 * The body is expected to the image contents base64 encoded.
	 */
	public suspend fun uploadCustomSplashscreen(`data`: ByteArray): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Branding/Splashscreen", pathParameters, queryParameters, data)
		return response
	}
}
