// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.AlbumInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.ArtistInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.BookInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.BoxSetInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.ExternalIdInfo
import org.jellyfin.sdk.model.api.MovieInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.MusicVideoInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.PersonLookupInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.RemoteSearchResult
import org.jellyfin.sdk.model.api.SeriesInfoRemoteSearchQuery
import org.jellyfin.sdk.model.api.TrailerInfoRemoteSearchQuery

public class ItemLookupApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Applies search criteria to an item and refreshes metadata.
	 *
	 * @param itemId Item id.
	 * @param replaceAllImages Optional. Whether or not to replace all images. Default: True.
	 */
	public suspend fun applySearchCriteria(
		itemId: UUID,
		replaceAllImages: Boolean? = true,
		`data`: RemoteSearchResult,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("replaceAllImages", replaceAllImages)
		}
		val response = api.post<Unit>("/Items/RemoteSearch/Apply/{itemId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get book remote search.
	 */
	public suspend fun getBookRemoteSearchResults(`data`: BookInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/Book", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get box set remote search.
	 */
	public suspend fun getBoxSetRemoteSearchResults(`data`: BoxSetInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/BoxSet", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get the item's external id info.
	 *
	 * @param itemId Item id.
	 */
	public suspend fun getExternalIdInfos(itemId: UUID): Response<List<ExternalIdInfo>> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<ExternalIdInfo>>("/Items/{itemId}/ExternalIdInfos", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get movie remote search.
	 */
	public suspend fun getMovieRemoteSearchResults(`data`: MovieInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/Movie", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get music album remote search.
	 */
	public suspend fun getMusicAlbumRemoteSearchResults(`data`: AlbumInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/MusicAlbum",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music artist remote search.
	 */
	public suspend fun getMusicArtistRemoteSearchResults(`data`: ArtistInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/MusicArtist",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get music video remote search.
	 */
	public suspend fun getMusicVideoRemoteSearchResults(`data`: MusicVideoInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/MusicVideo",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get person remote search.
	 */
	public suspend fun getPersonRemoteSearchResults(`data`: PersonLookupInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/Person", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get series remote search.
	 */
	public suspend fun getSeriesRemoteSearchResults(`data`: SeriesInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/Series", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Get trailer remote search.
	 */
	public suspend fun getTrailerRemoteSearchResults(`data`: TrailerInfoRemoteSearchQuery):
			Response<List<RemoteSearchResult>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<List<RemoteSearchResult>>("/Items/RemoteSearch/Trailer", pathParameters,
				queryParameters, data)
		return response
	}
}
