// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.buildMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.MetadataRefreshMode
import org.jellyfin.sdk.model.api.request.RefreshItemRequest

public class ItemRefreshApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Refreshes metadata for an item.
	 *
	 * @param itemId Item id.
	 * @param metadataRefreshMode (Optional) Specifies the metadata refresh mode.
	 * @param imageRefreshMode (Optional) Specifies the image refresh mode.
	 * @param replaceAllMetadata (Optional) Determines if metadata should be replaced. Only applicable
	 * if mode is FullRefresh.
	 * @param replaceAllImages (Optional) Determines if images should be replaced. Only applicable if
	 * mode is FullRefresh.
	 */
	public suspend fun refreshItem(
		itemId: UUID,
		metadataRefreshMode: MetadataRefreshMode? = MetadataRefreshMode.NONE,
		imageRefreshMode: MetadataRefreshMode? = MetadataRefreshMode.NONE,
		replaceAllMetadata: Boolean? = false,
		replaceAllImages: Boolean? = false,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(4) {
			put("metadataRefreshMode", metadataRefreshMode)
			put("imageRefreshMode", imageRefreshMode)
			put("replaceAllMetadata", replaceAllMetadata)
			put("replaceAllImages", replaceAllImages)
		}
		val data = null
		val response = api.post<Unit>("/Items/{itemId}/Refresh", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Refreshes metadata for an item.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun refreshItem(request: RefreshItemRequest): Response<Unit> = refreshItem(
		itemId = request.itemId,
		metadataRefreshMode = request.metadataRefreshMode,
		imageRefreshMode = request.imageRefreshMode,
		replaceAllMetadata = request.replaceAllMetadata,
		replaceAllImages = request.replaceAllImages,
	)
}
