// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.String
import kotlin.Unit
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDto
import org.jellyfin.sdk.model.api.MetadataEditorInfo

public class ItemUpdateApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets metadata editor info for an item.
	 *
	 * @param itemId The item id.
	 */
	public suspend fun getMetadataEditorInfo(itemId: UUID): Response<MetadataEditorInfo> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<MetadataEditorInfo>("/Items/{itemId}/MetadataEditor", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Updates an item.
	 *
	 * @param itemId The item id.
	 */
	public suspend fun updateItem(itemId: UUID, `data`: BaseItemDto): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Items/{itemId}", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Updates an item's content type.
	 *
	 * @param itemId The item id.
	 * @param contentType The content type of the item.
	 */
	public suspend fun updateItemContentType(itemId: UUID, contentType: String? = null):
			Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("contentType", contentType)
		}
		val data = null
		val response = api.post<Unit>("/Items/{itemId}/ContentType", pathParameters, queryParameters,
				data)
		return response
	}
}
