// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.delete
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.api.AddVirtualFolderDto
import org.jellyfin.sdk.model.api.CollectionTypeOptions
import org.jellyfin.sdk.model.api.MediaPathDto
import org.jellyfin.sdk.model.api.UpdateLibraryOptionsDto
import org.jellyfin.sdk.model.api.UpdateMediaPathRequestDto
import org.jellyfin.sdk.model.api.VirtualFolderInfo

public class LibraryStructureApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Add a media path to a library.
	 *
	 * @param refreshLibrary Whether to refresh the library.
	 */
	public suspend fun addMediaPath(refreshLibrary: Boolean? = false, `data`: MediaPathDto):
			Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(1) {
			put("refreshLibrary", refreshLibrary)
		}
		val response = api.post<Unit>("/Library/VirtualFolders/Paths", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Adds a virtual folder.
	 *
	 * @param name The name of the virtual folder.
	 * @param collectionType The type of the collection.
	 * @param paths The paths of the virtual folder.
	 * @param refreshLibrary Whether to refresh the library.
	 */
	public suspend fun addVirtualFolder(
		name: String? = null,
		collectionType: CollectionTypeOptions? = null,
		paths: Collection<String>? = emptyList(),
		refreshLibrary: Boolean? = false,
		`data`: AddVirtualFolderDto? = null,
	): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(4) {
			put("name", name)
			put("collectionType", collectionType)
			put("paths", paths)
			put("refreshLibrary", refreshLibrary)
		}
		val response = api.post<Unit>("/Library/VirtualFolders", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets all virtual folders.
	 */
	public suspend fun getVirtualFolders(): Response<List<VirtualFolderInfo>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<VirtualFolderInfo>>("/Library/VirtualFolders", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Remove a media path.
	 *
	 * @param name The name of the library.
	 * @param path The path to remove.
	 * @param refreshLibrary Whether to refresh the library.
	 */
	public suspend fun removeMediaPath(
		name: String? = null,
		path: String? = null,
		refreshLibrary: Boolean? = false,
	): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("path", path)
			put("refreshLibrary", refreshLibrary)
		}
		val data = null
		val response = api.delete<Unit>("/Library/VirtualFolders/Paths", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Removes a virtual folder.
	 *
	 * @param name The name of the folder.
	 * @param refreshLibrary Whether to refresh the library.
	 */
	public suspend fun removeVirtualFolder(name: String? = null, refreshLibrary: Boolean? = false):
			Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(2) {
			put("name", name)
			put("refreshLibrary", refreshLibrary)
		}
		val data = null
		val response = api.delete<Unit>("/Library/VirtualFolders", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Renames a virtual folder.
	 *
	 * @param name The name of the virtual folder.
	 * @param newName The new name.
	 * @param refreshLibrary Whether to refresh the library.
	 */
	public suspend fun renameVirtualFolder(
		name: String? = null,
		newName: String? = null,
		refreshLibrary: Boolean? = false,
	): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(3) {
			put("name", name)
			put("newName", newName)
			put("refreshLibrary", refreshLibrary)
		}
		val data = null
		val response = api.post<Unit>("/Library/VirtualFolders/Name", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Update library options.
	 */
	public suspend fun updateLibraryOptions(`data`: UpdateLibraryOptionsDto? = null): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Library/VirtualFolders/LibraryOptions", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Updates a media path.
	 */
	public suspend fun updateMediaPath(`data`: UpdateMediaPathRequestDto): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Library/VirtualFolders/Paths/Update", pathParameters,
				queryParameters, data)
		return response
	}
}
