// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.ItemFields
import org.jellyfin.sdk.model.api.RecommendationDto
import org.jellyfin.sdk.model.api.request.GetMovieRecommendationsRequest

public class MoviesApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets movie recommendations.
	 *
	 * @param userId Optional. Filter by user id, and attach user data.
	 * @param parentId Specify this to localize the search to a specific item or folder. Omit to use
	 * the root.
	 * @param fields Optional. The fields to return.
	 * @param categoryLimit The max number of categories to return.
	 * @param itemLimit The max number of items to return per category.
	 */
	public suspend fun getMovieRecommendations(
		userId: UUID? = null,
		parentId: UUID? = null,
		fields: Collection<ItemFields>? = emptyList(),
		categoryLimit: Int? = 5,
		itemLimit: Int? = 8,
	): Response<List<RecommendationDto>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(5) {
			put("userId", userId)
			put("parentId", parentId)
			put("fields", fields)
			put("categoryLimit", categoryLimit)
			put("itemLimit", itemLimit)
		}
		val data = null
		val response = api.`get`<List<RecommendationDto>>("/Movies/Recommendations", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets movie recommendations.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getMovieRecommendations(request: GetMovieRecommendationsRequest =
			GetMovieRecommendationsRequest()): Response<List<RecommendationDto>> = getMovieRecommendations(
		userId = request.userId,
		parentId = request.parentId,
		fields = request.fields,
		categoryLimit = request.categoryLimit,
		itemLimit = request.itemLimit,
	)
}
